% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sca_mcmc.R
\name{sca_mcmc}
\alias{sca_mcmc}
\title{Scalable MCMC for Dynamic GLMs}
\usage{
sca_mcmc(
  y,
  X,
  family = c("poisson", "pareto", "gamma"),
  method = c("ScaI", "ScaII", "ScaIII"),
  N_chain = 6L,
  iter = 10000L,
  burn = NULL,
  thin = 1L,
  T_max = 10,
  beta_init = NULL,
  verbose = TRUE
)
}
\arguments{
\item{y}{Numeric response vector (length n).}

\item{X}{n x p design matrix.}

\item{family}{Character: "poisson", "pareto", or "gamma".}

\item{method}{Character: "ScaI", "ScaII", or "ScaIII".}

\item{N_chain}{Integer >= 2, number of parallel chains.}

\item{iter}{Integer, total MCMC iterations per chain.}

\item{burn}{Integer, burn-in length (default = iter/2).}

\item{thin}{Integer, thinning interval (default = 1).}

\item{T_max}{Numeric > 1, hottest temperature (default = 10).}

\item{beta_init}{Optional matrix (N_chain x p) of initial coefficients.
If NULL, random starts are generated.}

\item{verbose}{Logical, print progress bar (default = TRUE).}
}
\value{
List with components:
\item{beta_chain}{3-D array (iter/thin x p x N_chain) of posterior samples.}
\item{family}{Character, distribution family used.}
\item{method}{Character, mutation-rate strategy used.}
}
\description{
Implements Algorithm 1 of the reference paper with three mutation-rate
strategies (ScaI/II/III) and three move types (mutation/crossover/exchange).
}
\examples{
set.seed(1)
X <- matrix(rnorm(200 * 3), 200, 3)
beta <- c(0.5, -0.2, 0.1)
y <- rgamma(200, shape = 2, rate = exp(X \%*\% beta))
fit <- sca_mcmc(y, X, family = "gamma", method = "ScaII",
                N_chain = 6, iter = 1000, burn = 500)

}
