% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iucn_here.R
\name{iucn_here}
\alias{iucn_here}
\title{Download species distribution information from IUCN}
\usage{
iucn_here(
  data_dir,
  species,
  synonyms = NULL,
  iucn_credential = NULL,
  overwrite = FALSE,
  progress_bar = FALSE,
  verbose = FALSE,
  return_data = TRUE
)
}
\arguments{
\item{data_dir}{(character) directory to save the data downloaded from
IUCN.}

\item{species}{(character) a vector of species names for which to retrieve
distribution information.}

\item{synonyms}{(data.frame) an optional data.frame containing synonyms of
the target species. The first column must contain the target species names,
and the second column their corresponding synonyms. Default is \code{NULL}.
See details for more information.}

\item{iucn_credential}{(character) your IUCN API key. Default is \code{NULL}, in
which case the function will attempt to read the API key from your R
environment. You can set it in advance using the \code{set_iucn_credentials()}
function.}

\item{overwrite}{(logical) whether to overwrite existing files. Default is
\code{FALSE}.}

\item{progress_bar}{(logical) whether to display a progress bar during
processing. If TRUE, the 'pbapply' package must be installed. Default is
\code{FALSE}.}

\item{verbose}{(logical) whether to display progress messages. Default is
\code{FALSE}.}

\item{return_data}{(logical) whether to return a data frame containing the
species distribution information downloaded from IUCN. Default is \code{TRUE}.}
}
\value{
A message indicating that the data were successfully saved in the directory
specified by \code{data_dir}.
If \code{return_data = TRUE}, the function additionally returns a data frame
containing the species distribution information retrieved from IUCN.
}
\description{
This function downloads information on species distributions from the IUCN
Red List, required for filtering occurrence records using specialists'
information via the \code{flag_iucn()} function.
}
\details{
This function uses the \code{rredlist::rl_species()} function to retrieve
distribution data from the IUCN Red List. The data include information at
the country and regional levels, following the World Geographical Scheme for
Recording Plant Distributions (WGSRPD) — but applicable to both plants and
animals.

Unfortunately, the range polygons available at
\url{https://www.iucnredlist.org/resources/spatial-data-download}
cannot be accessed automatically.

Because taxonomic information in IUCN may be outdated, you can optionally
provide a table of synonyms to broaden the search. The synonyms data.frame
should have the accepted species in the first column and their synonyms in
the second. See \code{RuHere::synonys} for an example.

The function also downloads the WGSRPD map used to represent distribution
regions.
}
\examples{
\dontrun{
# Define a directory to save the data
data_dir <- tempdir() # Here, a temporary directory

# Download species distribution information from IUCN
iucn_here(data_dir = data_dir, species = "Araucaria angustifolia")
}
}
