% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twalk_engine.R
\name{twalk_move}
\alias{twalk_move}
\title{Run a single t-walk move (step)}
\usage{
twalk_move(
  n_dim,
  log_post_fun,
  support_fun,
  x,
  U,
  xp,
  Up,
  at = 6,
  aw = 1.5,
  p_phi = min(n_dim, 4)/n_dim,
  p_traverse = 0.4918,
  p_walk = 0.4918,
  p_blow = 0.0082,
  ...
)
}
\arguments{
\item{...}{Arguments passed to `log_post_fun` and `support_fun`.}
}
\value{
A list containing the proposal and the acceptance probability.
}
\description{
Selects one of the four kernels, generates a proposal, and calculates
the Metropolis-Hastings acceptance probability.
}
\keyword{internal}
