% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gspaceGeom.R
\docType{data}
\name{GeomNodeSpace}
\alias{GeomNodeSpace}
\title{GeomNodeSpace: a ggplot2 prototype for GraphSpace-class methods}
\format{
An object of class \code{GeomNodeSpace} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 5.
}
\usage{
GeomNodeSpace
}
\description{
`GeomNodeSpace` is the underlying ggproto object used by 
\code{\link{geom_nodespace}} to draw node elements in a 2D graph layout. 
It produces point-like glyphs (typically circles) whose properties are 
controlled by aesthetics such as `x`, `y`, `size` and `colour`.

This geom is designed for graph/network diagrams, where node
attributes are often already in their final form (e.g., hex colors).
When used with identity scales, the appearance of nodes can be
fully controlled by the input data.
}
\section{Aesthetics}{


`GeomNodeSpace` understands the following aesthetics:

\itemize{
  \item `x` Horizontal position in `npc` \code{\link[grid]{unit}} (required).
  \item `y` Vertical position in `npc` \code{\link[grid]{unit}} (required).
  \item `size` Node size in `npc` \code{\link[grid]{unit}} (required).
  \item `fill` Node fill colour.
  \item `colour` Node line colour.
  \item `shape` Integer code between 0 and 25 
  (see \code{\link[graphics]{points}}).
  \item `linewidth` Line width, using 'lwd' standard graphics unit 
  (see \code{\link[grid]{gpar}}).
  \item `alpha` Transparency applied to fill and line colour.
}

These aesthetics follow ggplot2's conventions for point-like `geoms`.
}

\section{Drawing}{


The `draw_panel()` method transforms data into panel coordinates and
constructs a `grid::pointsGrob()` for rendering. Node size is expected 
to be normalized to the range `[0, 1]`, so it can be interpreted in graph 
space using `npc` unit.
}

\seealso{
\code{\link{geom_nodespace}}, \code{\link[ggplot2]{geom_point}}
}
\keyword{datasets}
