% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseline_data.R
\name{baseline_data}
\alias{baseline_data}
\title{Baseline pupil data to the average pupil size within a window}
\usage{
baseline_data(data, pupil, start, stop)
}
\arguments{
\item{data}{a PupillometryR dataframe}

\item{pupil}{a column name denoting pupil data}

\item{start}{start time of baseline window}

\item{stop}{stop time of baseline window}
}
\value{
A PupillometryR dataframe, with baselined pupil
}
\description{
This function is for use with the PupillometryR package to baseline each participant's pupil size to the
mean pupil size within a window.
This may not be necessary if you are doing purely within-subject analyses, but it is convenient for
comparison across subjects, and makes results more uniform.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
                               subject = ID,
                               trial = Trial,
                               time = Time,
                               condition = Type)
regressed_data <- regress_data(data = Sdata, pupil1 = RPupil, pupil2 = LPupil)
mean_data <- calculate_mean_pupil_size(data = regressed_data,
pupil1 = RPupil, pupil2 = LPupil)
base_data <- baseline_data(data = mean_data, pupil = mean_pupil, start = 0, stop = 100)
}
