% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PupilPre.R
\name{PupilPre}
\alias{PupilPre}
\alias{_PACKAGE}
\title{PupilPre: Preprocessing Pupil Size Data.}
\description{
The PupilPre package provides a set of functions for preparing pupil size data
collected with SR Research Eyelink eye trackers.
}
\section{Processing functions}{

\itemize{
  \item The function \code{\link{ppl_prep_data}} returns a data table with
  correctly assigned classes for important columns.
  \item The function \code{\link{ppl_select_recorded_eye}} returns a data table
  with data from the the recorded eye in new columns (IA_ID and IA_LABEL).
  \item The function \code{\link{recode_off_screen}} recodes samples with NA if
  gaze coordinates indicate that the sample was taken while the pupil was
  off-screen.
  \item The function \code{\link{ppl_rm_extra_DVcols}} removes DataViewer columns
  that are not necessary for preprocessing with this package.
  \item The function \code{\link{clean_blink}} returns a data table
  for which blinks have been removed based on the parameters provided.
  \item The function \code{\link{clean_artifact}} returns a data table
  for which artifacts have been removed based on the parameters provided.
  \item The function \code{\link{apply_cleanup_change}} applies user-selected
  changes to the automatic cleanup.
  \item The function \code{\link{apply_user_cleanup}} returns a data table
  for which the manually selected artifacts have been removed.
  \item The function \code{\link{rm_sparse_events}} removes events
  that do not contain enough data in the baseline and/or critical windows,
  as specified by the user.
  \item The function \code{\link{interpolate_NAs}} returns a data table in which
  NAs have been replaced using linear interpolation.
  \item The function \code{\link{apply_butter}} applies a Butterworth
  filter to the pupil size data.
  \item The function \code{\link{trim_filtered}} removes a specified number
  of milliseconds from the beginning and the end of each filtered event, as
  to remove artifacts created by the filter.
  \item The function \code{\link{downsample}} returns a data table for which
  the data have been downsampled using the specified sampling rate.
  \item The function \code{\link{baseline}} returns a data table for which
  the pupil data have been baselined using the specified method.
}
}

\section{Utility functions}{

\itemize{
  \item The function \code{\link{ppl_check_eye_recording}} returns a summary
  of whether or not the dataset contains gaze data in both the Right and
  Left interest area columns.
  \item The function \code{\link{blink_summary}} returns a summary of
  Eyelink marked blinks by Event, Subject, or Item.
  \item The function \code{\link{NA_summary}} returns a summary of missing
  data by Event, Subject, or Item.
  \item The function \code{\link{check_baseline}} examines the data within
  a specified baseline window.
  \item The function \code{\link{compare_summary}} returns a summary of
  comparison between the columns Pupil and Pupil_Previous.
}
}

\section{Plotting functions}{

\itemize{
  \item The function \code{\link{ppl_plot_avg}} returns a plot of the grand
  or conditional averages of pupil dilation along with error bars.
  \item The function \code{\link{ppl_plot_avg_contour}} returns a contour plot of
  the conditional average of pupil dilation over Time and a specified continuous variable.
  \item The function \code{\link{ppl_plot_avg_cdiff}} returns a plot of the
  average difference between two conditions for pupil dilation with error bars.
  \item The function \code{\link{plot_events}} returns image files containing
  plots for each event by a group and saves into a specified directory.
}
}

\section{Interactive functions}{

\itemize{
  \item The function \code{\link{user_cleanup_app}} opens a Shiny app
  for identifying and marking datapoints associated with artifacts.
  \item The function \code{\link{plot_summary_app}} opens a Shiny app for
  inspecting by-subject or by-item averages within a specified time window.
  \item The function \code{\link{plot_compare_app}} opens a Shiny app for
  inspecting events for comparing the current pupil column to the
  previous pupil column.
  \item The function \code{\link{verify_cleanup_app}} plots the data
  points changed during the previously completed auto cleanup, allowing the
  user to reject the cleanup for specific events.
  \item The function \code{\link{butter_filter_app}} produces a plot of
  filtered pupil data over the original data to visually inspect the effect
  of different filter settings.
}
}

\section{Notes}{

\itemize{
\item The vignettes are available via \code{browseVignettes(package = "PupilPre")}.
\item A list of all available functions is provided in
\code{help(package = "PupilPre")}.
\item This package can be cited using the information obtained from
\code{citation("PupilPre") or print(citation("PupilPre"), bibtex = TRUE)}
}
}

\author{
Aki-Juhani Kyröläinen, Vincent Porretta, Jacolien van Rij, Juhani Järvikivi

Maintainer: Aki-Juhani Kyröläinen, (\email{akkyro@gmail.com})
}
