\name{peleg}
\alias{peleg}
\title{Peleg model }
\usage{
peleg (M_infinite, k1, k2, t)
}
\arguments{
\item{M_infinite}{maximum migrated amount}
\item{k1}{This constant is associated with first-order kinetics, reflecting the
initial release rate}
\item{k2}{This constant is associated with second-order kinetics. It typically
represents the influence of slower processes such as diffusion, polymer
swelling, or matrix degradation that affect drug release over time}
\item{t}{time}
}
\value{
Amount of drug released at time t Gallic Acid Equivalents per gram (GAE/gm)
}
\description{Peleg model describes both the early-stage release dynamics and the long-term stabilization phase, making it particularly useful for evaluating overall migration performance and predicting equilibrium release behaviour in active packaging systems.

Principle:

This model is based on the principle of an empirical, time-dependent approach that characterizes release behaviour through two kinetic constants representing the initial release rate and the system’s approach to equilibrium. The model assumes that the release process is rapid at the initial stage and gradually decreases over time as the system approaches a maximum release capacity (Ramos et al., 2014; Malekjani et al., 2024).

}
\examples{
  peleg (2, 0.02, 0.015, 24)
}
\references{
Ramos, M., Beltrán, A., Peltzer, M., Valente, A. J., & del Carmen Garrigós, M. (2014). Release and antioxidant activity of carvacrol and thymol from polypropylene active packaging films. LWT-Food Science and Technology, 58(2), 470-477.

Malekjani, N., Karimi, R., Assadpour, E., & Jafari, S. M. (2024). Control of release in active packaging/coating for food products; approaches, mechanisms, profiles, and modeling. Critical reviews in food science and nutrition, 64(29), 10789-10811.
}
\keyword{Peleg model}
