% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rAUPDC.R
\name{rAUDPC}
\alias{rAUDPC}
\title{Relative Area Under the Disease Progress Curve (rAUDPC)}
\usage{
rAUDPC(time, severity, max_severity)
}
\arguments{
\item{time}{A numeric vector of time points (e.g., days after sowing or inoculation).
Values must be in strictly increasing order.}

\item{severity}{A numeric vector of disease severity values
corresponding to each time point.}

\item{max_severity}{A numeric value representing the maximum possible
disease severity on the rating scale.}
}
\value{
A numeric value representing relative AUDPC (percentage).
}
\description{
Calculates the Relative Area Under the Disease Progress Curve (rAUDPC),
which expresses AUDPC as a percentage of the maximum possible disease
development over the observation period.
}
\details{
rAUDPC is calculated as:
\deqn{
rAUDPC = \left( \frac{AUDPC}{(T_{max} - T_{min}) \times Y_{max}} \right) \times 100
}

where \eqn{AUDPC} is the area under the disease progress curve,
\eqn{T_{max}} and \eqn{T_{min}} are the maximum and minimum time points,
and \eqn{Y_{max}} is the maximum disease severity.
}
\examples{
{
time <- c(0, 7, 14, 21, 28)
severity <- c(5, 15, 30, 45, 60)
max_severity <- 100
rAUDPC(time, severity, max_severity)
}
}
