% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCBN-find-copula-specified.R
\name{is_cond_copula_specified}
\alias{is_cond_copula_specified}
\title{Checks if a given (conditional) copula has already been specified}
\usage{
is_cond_copula_specified(DAG, order_hash, w, v, cond)
}
\arguments{
\item{DAG}{Directed Acyclic Graph object corresponding to the model}

\item{order_hash}{hashmap of orders of the parental sets}

\item{w}{node in DAG}

\item{v}{node in DAG}

\item{cond}{vector of nodes in DAG.
It is assumed to have been already sorted.}
}
\value{
\code{TRUE} if the conditional copula \eqn{C_{w, v | cond}}
has been specified in the model
}
\description{
Checks if a given (conditional) copula has already been specified
}
\examples{

DAG = create_empty_DAG(3)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

order_hash = r2r::hashmap()
order_hash[['U3']] = c("U1", "U2")

is_cond_copula_specified(DAG = DAG, order_hash = order_hash,
                    w = "U1", v = "U3", cond = c())
# returns TRUE because the copula c_{1,3} is known

is_cond_copula_specified(DAG = DAG, order_hash = order_hash,
                    w = "U2", v = "U3", cond = c())
# returns FALSE because the copula c_{2,3} is not known

is_cond_copula_specified(DAG = DAG, order_hash = order_hash,
                    w = "U2", v = "U3", cond = c("U1"))
# returns TRUE because the copula c_{2,3 | 1} is known

}
