% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_omics.R
\name{plot_omics}
\alias{plot_omics}
\title{Plot Omics Data (PCA, Heatmap, or Density)}
\arguments{
\item{data}{A numeric matrix or data frame containing omics measurements.}

\item{type}{A character string specifying the visualization type. One of "pca", "heatmap", or "density".}
}
\value{
A plot object (for PCA and density) or a heatmap visualization.
}
\description{
Visualizes omics datasets using PCA, heatmap, or density plot options.
}
\examples{
\donttest{
data <- matrix(rnorm(100), nrow = 10)
plot_omics(data, type = "pca")
}
}
