% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetOutcomeInfo.R
\name{getTargetTable}
\alias{getTargetTable}
\title{Extract the target cohorts and where they are used in the analyses.}
\usage{
getTargetTable(
  connectionHandler,
  schema,
  cgTablePrefix = "cg_",
  cTablePrefix = "c_",
  ciTablePrefix = "ci_",
  cmTablePrefix = "cm_",
  sccsTablePrefix = "sccs_",
  plpTablePrefix = "plp_",
  databaseTable = "database_meta_data",
  getIncidenceInclusion = TRUE,
  getCharacterizationInclusion = TRUE,
  getPredictionInclusion = TRUE,
  getCohortMethodInclusion = TRUE,
  getSccsInclusion = TRUE,
  printTimes = FALSE
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{cTablePrefix}{The prefix used for the characterization results tables}

\item{ciTablePrefix}{The prefix used for the cohort incidence results tables}

\item{cmTablePrefix}{The prefix used for the cohort method results tables}

\item{sccsTablePrefix}{The prefix used for the cohort generator results tables}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{getIncidenceInclusion}{Whether to check useage of the cohort in incidence}

\item{getCharacterizationInclusion}{Whether to check useage of the cohort in characterization}

\item{getPredictionInclusion}{Whether to check useage of the cohort in prediction}

\item{getCohortMethodInclusion}{Whether to check useage of the cohort in cohort method}

\item{getSccsInclusion}{Whether to check useage of the cohort in SCCS}

\item{printTimes}{Whether to print how long each query took}
}
\value{
Returns a data.frame with the columns: 
\itemize{
 \item{cohortId the number id for the target cohort}
 \item{cohortName the name of the cohort}
 \item{subsetParent the number id of the parent cohort}
 \item{subsetDefinitionId the number id of the subset}
 \item{subsetDefinitionJson the json of the subset}
 \item{subsetCohortIds the ids of any cohorts that are restricted to by the subset logic}
 \item{numDatabase number of databases with the cohort}
 \item{databaseString all the names of the databases with the cohort}
 \item{databaseCount all the names of the databases with the cohort and their sizes}
 \item{minSubjectCount number of subjects in databases with lowest count}
 \item{maxSubjectCount number of subjects in databases with highest count}
 \item{minEntryCount number of entries in databases with lowest count}
 \item{maxEntryCount number of entries in databases with highest count}
 \item{cohortIncidence whether the cohort was used in cohort incidence}
 \item{databaseComparator whether the cohort was used in database comparator}
 \item{cohortComparator whether the cohort was used in cohort comparator}
 \item{dechalRechal whether the cohort was used in dechallenge rechallenge}
 \item{riskFactors whether the cohort was used in risk factors}
 \item{caseSeries whether the cohort was used in case series analysis}
 \item{timeToEvent whether the cohort was used in time to event}
 \item{prediction whether the cohort was used in prediction}
 \item{cohortMethod whether the cohort was used in cohort method}
 \item{selfControlledCaseSeries whether the cohort was used in self controlled case series}
}
}
\description{
This function extracts the target cohorts, the number of subjects/entries and where the cohort was used.
}
\details{
Specify the connectionHandler, the schema and the table prefixes
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

targetTable <- getTargetTable(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other helper: 
\code{\link{addTarColumn}()},
\code{\link{formatBinaryCovariateName}()},
\code{\link{getExampleConnectionDetails}()},
\code{\link{getOutcomeTable}()},
\code{\link{kableDark}()},
\code{\link{printReactable}()},
\code{\link{removeSpaces}()}
}
\concept{helper}
