% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationQueries.R
\name{getSccsEstimation}
\alias{getSccsEstimation}
\title{Extract the self controlled case series (sccs) results}
\usage{
getSccsEstimation(
  connectionHandler,
  schema,
  sccsTablePrefix = "sccs_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetIds = NULL,
  outcomeIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{sccsTablePrefix}{The prefix used for the cohort generator results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseName the database name}
 \item{databaseId the database id}
 \item{exposuresOutcomeSetId the exposure outcome set identifier}
 \item{analysisId the analysis unique identifier}
 \item{description an analysis description}
 \item{targetName the target name}
 \item{targetId the target cohort id}
 \item{outcomeName the outcome name}
 \item{outcomeId the outcome cohort id}
 \item{indicationName the indication name}
 \item{indicatonId the indication cohort id}
 \item{covariateName whether main or secondary analysis}
 \item{covariateId the analysis id}
 \item{outcomeSubjects The number of subjects with at least one outcome.}
 \item{outcomeEvents The number of outcome events.}
 \item{outcomeObservationPeriods The number of observation periods containing at least one outcome.}
 \item{covariateSubjects The number of subjects having the covariate.}
 \item{covariateDays The total covariate time in days.}
 \item{covariateEras The number of continuous eras of the covariate.}
 \item{covariateOutcomes The number of outcomes observed during the covariate time.}
 \item{observedDays The number of days subjects were observed.}
 \item{rr the relative risk}
 \item{ci95Lb the lower bound of the 95 percent confidence interval for the relative risk}
 \item{ci95Ub the upper bound of the 95 percent confidence interval for the relative risk}
 \item{p the p-value for the relative risk}
 \item{logRr the log of the relative risk}
 \item{seLogRr the standard error or the log of the relative risk}
 \item{calibratedRr the calibrated relative risk}
 \item{calibratedCi95Lb the lower bound of the 95 percent confidence interval for the calibrated relative risk}
 \item{calibratedCi95Ub the upper bound of the 95 percent confidence interval for the calibrated relative risk}
 \item{calibratedP the calibrated p-value}
 \item{calibratedOneSidedP the calibrated one sided p-value}
 \item{calibratedLogRr the calibrated log of the relative risk}
 \item{calibratedSeLogRr the calibrated log of the relative risk standard error}
 \item{llr The log of the likelihood ratio (of the MLE vs the null hypothesis of no effect).}
 \item{mdrr The minimum detectable relative risk.}
 \item{unblind Whether the results can be unblinded}
 \item{unblindForEvidenceSynthesis whether the results can be unblinded for the meta analysis.}
 }
}
\description{
This function extracts the single database sccs estimates
}
\details{
Specify the connectionHandler, the schema and the target/outcome cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

sccsEst <- getSccsEstimation(
  connectionHandler = connectionHandler, 
  schema = 'main',
  targetIds = 1,
  outcomeIds = 3
)

}
\seealso{
Other Estimation: 
\code{\link{getCMEstimation}()},
\code{\link{getCmDiagnosticsData}()},
\code{\link{getCmMetaEstimation}()},
\code{\link{getCmNegativeControlEstimates}()},
\code{\link{getCmOutcomes}()},
\code{\link{getCmPropensityModel}()},
\code{\link{getCmTable}()},
\code{\link{getCmTargets}()},
\code{\link{getSccsDiagnosticsData}()},
\code{\link{getSccsMetaEstimation}()},
\code{\link{getSccsModel}()},
\code{\link{getSccsNegativeControlEstimates}()},
\code{\link{getSccsOutcomes}()},
\code{\link{getSccsTable}()},
\code{\link{getSccsTargets}()},
\code{\link{getSccsTimeToEvent}()},
\code{\link{plotCmEstimates}()},
\code{\link{plotSccsEstimates}()}
}
\concept{Estimation}
