\name{headneck44}
\alias{headneck44}
\title{Head and Neck Cancer Survival Times}

\description{
A dataset containing survival times (in days) of 44 patients with Head and Neck
cancer who were treated using radiotherapy. The dataset was originally reported
by Efron (1988) in his work on logistic regression, survival analysis, and
Kaplan--Meier methods.
}

\usage{
headneck44
}

\format{
A numeric vector of length 44 containing survival times (in days).
}

\value{
An object of class \code{"numeric"}.

The vector consists of 44 observed survival times (in days), each corresponding
to a single patient diagnosed with Head and Neck cancer and treated with
radiotherapy. Each value represents the time from treatment initiation to
death or last follow-up. The dataset is commonly used as input for illustrating
and comparing nonparametric survival analysis methods, including
Kaplan--Meier estimation.
}

\details{
This dataset has been widely used in survival analysis literature, particularly
for demonstrating Kaplan--Meier estimation and related nonparametric survival
techniques. The patients in the study were treated with radiotherapy, and their
survival times were recorded.
}

\references{
Efron, B. (1988). Logistic regression, survival analysis and the Kaplan--Meier
curve. \emph{Journal of the American Statistical Association}, 83(402), 414--425.
}

\examples{
summary(headneck44)

plot(
  headneck44,
  main = "Head and Neck Cancer Survival Times",
  ylab = "Days"
)
}

\keyword{datasets}
