% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsi_biplot.R
\name{rsi_biplot}
\alias{rsi_biplot}
\title{Create GGE-style biplot annotated by RSI}
\usage{
rsi_biplot(data, y, gen, env, rsi_table = NULL)
}
\arguments{
\item{data}{Data frame with genotype, environment, and response columns.}

\item{y}{Response variable column.}

\item{gen}{Genotype column.}

\item{env}{Environment column.}

\item{rsi_table}{Optional RSI table from compute_rsi().}
}
\value{
A ggplot object of the biplot.
}
\description{
Create GGE-style biplot annotated by RSI
}
\examples{
library(NPStability)
data(example_data)
rsi_results <- compute_rsi(example_data, Yield, Gen, Env)
rsi_biplot(example_data, Yield, Gen, Env, rsi_table = rsi_results)

}
