% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engines_el_impl_equations.R
\name{el_build_equation_system}
\alias{el_build_equation_system}
\title{Empirical likelihood estimating equations for SRS}
\usage{
el_build_equation_system(
  family,
  missingness_model_matrix,
  auxiliary_matrix,
  respondent_weights,
  N_pop,
  n_resp_weighted,
  mu_x_scaled
)
}
\description{
Returns a function that evaluates the stacked EL system for
\eqn{\theta = (\beta, z, \lambda_x)} with \eqn{z = \operatorname{logit}(W)}.
Blocks correspond to:
\enumerate{
\item missingness model score equations in \eqn{\beta},
\item the response-rate equation in \eqn{W},
\item auxiliary moment constraints in \eqn{\lambda_x}.
}
}
\details{
When no auxiliaries are present the last block is omitted. The system
matches QLS equations 7-10. We cap \eqn{\eta}, clip \eqn{w_i} in ratios,
and guard \eqn{D_i} away from zero to ensure numerical stability.

\strong{Guarding policy:}
\itemize{
\item Cap \eqn{\eta}:
\code{eta <- pmax(pmin(eta, get_eta_cap()), -get_eta_cap())}.
\item Compute \code{w <- family$linkinv(eta)} and clip to
\code{[1e-12, 1 - 1e-12]} when used in ratios.
\item Denominator floor:
\code{Di <- pmax(Di_raw, nmar_get_el_denom_floor())}. In the Jacobian,
terms that depend on \code{d(1/Di)/d(.)} are multiplied by
\code{active = 1(Di_raw > floor)} to match the clamped equations.
}
}
\keyword{internal}
