% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForOpt.R
\name{InputsForOpt}
\alias{InputsForOpt}
\title{Generates inputs necessary to build the likelihood function for the ATSM model}
\usage{
InputsForOpt(
  InitialSampleDate,
  FinalSampleDate,
  ModelType,
  Yields,
  GlobalMacro,
  DomMacro,
  FactorLabels,
  Economies,
  DataFrequency,
  GVARlist = NULL,
  JLLlist = NULL,
  WishBRW = FALSE,
  BRWlist = NULL,
  UnitYields = "Month",
  CheckInputs = TRUE,
  BS_Adj = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{InitialSampleDate}{Start date of the sample period in the format "dd-mm-yyyy"}

\item{FinalSampleDate}{End date of the sample period in the format "dd-mm-yyyy"}

\item{ModelType}{character. Model type to be estimated. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{Yields}{numerical matrix with time series of yields (\code{J x Td} or \code{CJ x Td})}

\item{GlobalMacro}{numerical matrix with time series of the global risk factors (\code{G x Td})}

\item{DomMacro}{numerical matrix with time series of the country-specific risk factors for all \code{C} countries ( \code{C X Td} or  \code{CM x Td})}

\item{FactorLabels}{list. Labels for all variables present in the model, as returned by \code{\link{LabFac}}.}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{DataFrequency}{character. Data frequency. Permissible choices: "Daily All Days", "Daily Business Days", "Weekly", "Monthly", "Quarterly", "Annually".}

\item{GVARlist}{list. Inputs for GVAR model estimation. See details below.}

\item{JLLlist}{list. Inputs for JLL model estimation. See details below.}

\item{WishBRW}{logical. Whether to estimate the physical parameter model with bias correction (see \code{\link{Bias_Correc_VAR}}). Default is FALSE.}

\item{BRWlist}{list. Inputs for bias-corrected estimation.}

\item{UnitYields}{character. Maturity unit of yields. Permissible choices: "Month" or "Year". Default is "Month".}

\item{CheckInputs}{logical. Whether to perform a prior check on the consistency of the provided input list. Default is TRUE.}

\item{BS_Adj}{logical. Whether to adjust the global series for the sepQ models in the Bootstrap setting. Default is FALSE.}

\item{verbose}{logical. Print progress messages. Default is TRUE.}
}
\value{
An object of class 'ATSMModelInputs' containing the necessary inputs for performing the model optimization.
}
\description{
Generates inputs necessary to build the likelihood function for the ATSM model
}
\section{Permissible options for GVARlist}{

\itemize{
  \item \code{VARXtype}: "unconstrained" or "constrained"
  \item \code{W_type}: "Time-varying" or "Sample Mean"
  \item \code{t_First_Wgvar}, \code{t_Last_Wgvar}: year as character
}
}

\section{Permissible options for JLLlist}{

\itemize{
  \item \code{DomUnit}: name of the dominant economy or \code{None}
  \item \code{WishSigmas}: TRUE (estimate variance-covariance matrices) or FALSE
  \item \code{SigmaNonOrtho}: NULL or \code{K x K} matrix
}
}

\section{Permissible options for BRWlist}{

\itemize{
  \item \code{BiasCorrection}: TRUE (bias-corrected) or FALSE
  \item \code{flag_mean}: TRUE (mean) or FALSE (median)
  \item \code{gamma}: numeric adjustment parameter
  \item \code{N_iter}: number of iterations
  \item \code{N_burn}: number of burn-in iterations
  \item \code{B}: number of bootstrap samples
  \item \code{checkBRW}: TRUE or FALSE
  \item \code{B_check}: number of bootstrap samples for closeness check
}
}

\section{General Notation}{

\itemize{
  \item \code{Td} model time series dimension.
  \item \code{C} number of countries in the system.
  \item \code{G} number of global unspanned factors.
  \item \code{M} number of country-specific unspanned factors.
  \item \code{K} total number of risk factors.
  \item \code{J} number of bond yields per country used in estimation.
}
}

\section{Available Methods}{

- `print(object)`
- `summary(object)`
}

\examples{
\donttest{
# Example 1:
data(GlobalMacro)
data(DomMacro)
data(Yields)

ModelType <- "JPS original"
Economies <- "Mexico"
t0 <- "01-05-2007" # Initial Sample Date (Format: "dd-mm-yyyy")
tF <- "01-12-2018" # Final Sample Date (Format: "dd-mm-yyyy")
N <- 3
GlobalVar <- c("Gl_Eco_Act") # Global Variables
DomVar <- c("Eco_Act") # Domestic Variables
FactorLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)

DataFreq <- "Monthly"

ATSMInputs <- InputsForOpt(t0, tF, ModelType, Yields, GlobalMacro, DomMacro,
  FactorLabels, Economies, DataFreq,
  CheckInputs = FALSE, verbose = FALSE
)

# Example 2:
LoadData("CM_2024")

ModelType <- "GVAR multi"

Economies <- c("China", "Brazil", "Mexico", "Uruguay")
t0 <- "01-05-2007" # InitialSampleDate (Format: "dd-mm-yyyy")
tF <- "01-12-2019" # FinalSampleDate (Format: "dd-mm-yyyy")
N <- 2
GlobalVar <- c("Gl_Eco_Act", "Gl_Inflation") # Global Variables
DomVar <- c("Inflation") # Domestic Variables
FactorLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)

DataFreq <- "Monthly"
GVARlist <- list(
  VARXtype = "unconstrained", W_type = "Sample Mean",
  t_First_Wgvar = "2007", t_Last_Wgvar = "2019", DataConnectedness = TradeFlows
)

ATSMInputs <- InputsForOpt(t0, tF, ModelType, Yields, GlobalMacro, DomMacro,
  FactorLabels, Economies, DataFreq, GVARlist,
  CheckInputs = FALSE, verbose = FALSE
)

# Example 3:
LoadData("CM_2024")

ModelType <- "JLL original"

Economies <- c("China", "Brazil", "Uruguay")
t0 <- "01-05-2007" # InitialSampleDate (Format: "dd-mm-yyyy")
tF <- "01-12-2019" # FinalSampleDate (Format: "dd-mm-yyyy")
N <- 2
GlobalVar <- c("Gl_Eco_Act", "Gl_Inflation") # Global Variables
DomVar <- c("Eco_Act", "Inflation") # Domestic Variables
FactorLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)

JLLinputs <- list(DomUnit = "China")

DataFrequency <- "Monthly"

ATSMInputs <- InputsForOpt(t0, tF, ModelType, Yields, GlobalMacro, DomMacro,
  FactorLabels, Economies, DataFreq,
  JLLlist = JLLinputs,
  CheckInputs = FALSE, verbose = FALSE
)
}
}
