% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.diversity.R
\name{add.diversity}
\alias{add.diversity}
\title{Add additional diverse material to a population}
\usage{
add.diversity(
  population,
  breeding.size = 100,
  selection.rate = 0.5,
  pool.gen = NULL,
  pool.database = NULL,
  pool.cohorts = NULL,
  target.gen = NULL,
  target.database = NULL,
  target.cohorts = NULL,
  target.value = NULL,
  reduction.multiplier = 5,
  name.cohort = NULL,
  sex.quota = NULL,
  add.gen = 1,
  target.direction = NULL,
  verbose = TRUE,
  store.comp.times = TRUE,
  use.recalculate.manual = FALSE,
  pop1 = NULL,
  export.pop1 = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{breeding.size}{Number of individuals to generate (default: 100)}

\item{selection.rate}{Proportion of individuals to select in each breeding cycle (default: 0.5)}

\item{pool.gen}{Generations of individuals to consider as founder pool to start from (default: NULL)}

\item{pool.database}{Groups of individuals to consider as founder pool to start from (default: NULL)}

\item{pool.cohorts}{Cohorts of individuals to consider as founder pool to start from (default: NULL)}

\item{target.gen}{Generations of individuals to consider to calculate target genomic value to get to (default: NULL)}

\item{target.database}{Groups of individuals to consider to calculate target genomic value to get to (default: NULL)}

\item{target.cohorts}{Cohorts of individuals to consider to calculate target genomic value to get to (default: NULL)}

\item{target.value}{Target genomic value to get (default: NULL - calculated based on target.gen/database/cohorts)}

\item{reduction.multiplier}{Traits that already exceed the target are bred against. Weighting is scaled by this factor.}

\item{name.cohort}{Name of the newly added cohort}

\item{sex.quota}{Share of newly added female individuals (default: 0.5)}

\item{add.gen}{Generation you want to add the new individuals to (default: 1)}

\item{target.direction}{Manual select with traits are supposed to increase / decrease (1 target high, -1 target low)}

\item{verbose}{Set to FALSE to not display any prints}

\item{store.comp.times}{If TRUE store computation times in $info$comp.times.general (default: TRUE)}

\item{use.recalculate.manual}{Set to TRUE to use recalculate.manual to calculate genomic values (all individuals and traits jointly, default: FALSE)}

\item{pop1}{Population to start with as founder pool (default: NULL - generation from pool.gen/database/cohorts)}

\item{export.pop1}{Default: FALSE. Exporting this is helpful if add.diversity is used frequently to avoid initializing this multiple times}
}
\value{
population list with newly added individuals
}
\description{
Function to simulate and add additional diverse material to a population
}
\examples{
data(ex_pop)
population <- add.diversity(ex_pop, pool.gen  = 1, target.gen = 5)
}
