% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7.stability.R
\name{Cohesion}
\alias{Cohesion}
\alias{plot.cohesion}
\title{Cohesion calculation}
\usage{
Cohesion(otutab, reps = 200, threads = 1, mycor = NULL, verbose = TRUE)

\method{plot}{cohesion}(x, group, metadata, mode = 1, ...)
}
\arguments{
\item{otutab}{otutab}

\item{reps}{iteration time}

\item{threads}{threads}

\item{mycor}{a correlation matrix you want to use, skip the null model build when mycor is not NULL, default: NULL}

\item{verbose}{verbose}

\item{x}{\code{Cohesion()} result (cohesion object)}

\item{group}{group name in colnames(metadata)}

\item{metadata}{metadata}

\item{mode}{plot mode, 1~2}

\item{...}{additional arguments for \code{\link[pcutils]{group_box}} (mode=1) or \code{\link[pcutils]{group_box}} (mode=2)}
}
\value{
Cohesion object: a list with two dataframe

a ggplot
}
\description{
Cohesion calculation

Plot cohesion
}
\examples{
\donttest{
data("otutab", package = "pcutils")
# set reps at least 99 when you run.
Cohesion(otutab[1:50, ], reps = 19) -> cohesion_res
if (requireNamespace("ggpubr")) {
  plot(cohesion_res, group = "Group", metadata = metadata, mode = 1)
  plot(cohesion_res, group = "Group", metadata = metadata, mode = 2)
}
}
}
\references{
Herren, C. M. & McMahon, K. (2017) Cohesion: a method for quantifying the connectivity of microbial communities. doi:10.1038/ismej.2017.91.
}
