% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_dep_t_diff.R
\name{d_dep_t_diff}
\alias{d_dep_t_diff}
\alias{d.dep.t.diff}
\title{Cohen's d for Paired t Using the SD of Difference Scores}
\usage{
d_dep_t_diff(mdiff, sddiff, n, a = 0.05)

d.dep.t.diff(mdiff, sddiff, n, a = 0.05)
}
\arguments{
\item{mdiff}{Mean of the difference scores.}

\item{sddiff}{Standard deviation of the difference scores.}

\item{n}{Sample size (number of paired observations).}

\item{a}{Significance level (alpha) for the confidence interval.
Must be in (0, 1).}
}
\value{
A list with the following elements:
\describe{
  \item{d}{Cohen's \eqn{d_z}.}
  \item{dlow}{Lower limit of the \eqn{(1-\alpha)}
confidence interval for \eqn{d_z}.}
  \item{dhigh}{Upper limit of the \eqn{(1-\alpha)}
confidence interval for \eqn{d_z}.}
  \item{mdiff}{Mean difference score.}
  \item{Mlow, Mhigh}{Confidence interval bounds for the mean difference.}
  \item{sddiff}{Standard deviation of the difference scores.}
  \item{se}{Standard error of the difference scores.}
  \item{n}{Sample size.}
  \item{df}{Degrees of freedom (\eqn{n - 1}).}
  \item{t}{t-statistic.}
  \item{p}{p-value.}
  \item{estimate}{APA-style formatted string for reporting
\eqn{d_z} and its CI.}
  \item{statistic}{APA-style formatted string for reporting
the t-statistic and p-value.}
}
}
\description{
**Note on function and output names:**
This effect size is now implemented with the snake_case function name
`d_dep_t_diff()` to follow modern R style guidelines. The original
dotted version `d.dep.t.diff()` is still available as a wrapper for
backward compatibility, and both functions return the same list. The
returned object includes both the original element names (e.g.,
`mdiff`, `Mlow`, `Mhigh`, `sddiff`) and newer snake_case aliases
(e.g., `m_diff`, `m_diff_lower_limit`, `m_diff_upper_limit`, `sd_diff`).
New code should prefer `d_dep_t_diff()` and the snake_case output
names, but existing code using the older names will continue to work.
}
\details{
Compute Cohen's \eqn{d_z} and a noncentral-t confidence interval for
repeated-measures (paired-samples) designs using the **standard deviation
of the difference scores** as the denominator.


The effect size is defined as:
\deqn{d_z = \frac{\bar{X}_D}{s_D}}
where \eqn{\bar{X}_D} is the mean of the difference scores and \eqn{s_D} is
the standard deviation of the difference scores.

The corresponding t statistic for the paired-samples t-test is:
\deqn{t = \frac{\bar{X}_D}{s_D / \sqrt{n}}}

See the online example for additional context:
\href{https://www.aggieerin.com/shiny-server/tests/deptdiffm.html}{Learn more on our example page.}
}
\examples{
# Example derived from the "dept_data" dataset included in MOTE

# Suppose seven people completed a measure of belief in the supernatural
# before and after watching a sci-fi movie.
# Higher scores indicate stronger belief.

t.test(dept_data$before, dept_data$after, paired = TRUE)

# Direct entry of summary statistics:
d_dep_t_diff(mdiff = 1.14, sddiff = 2.12, n = 7, a = .05)

# Equivalent shorthand:
d_dep_t_diff(1.14, 2.12, 7, .05)

# Using raw data from the dataset:
d_dep_t_diff(mdiff = mean(dept_data$before - dept_data$after),
             sddiff = sd(dept_data$before - dept_data$after),
             n = length(dept_data$before),
             a = .05)
}
\keyword{cohen's}
\keyword{d}
\keyword{dependent}
\keyword{effect}
\keyword{measures}
\keyword{repeated}
\keyword{size}
\keyword{t-test}
