% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructDobjCostSTRS.R
\name{constructDobjCostSTRS}
\alias{constructDobjCostSTRS}
\title{Constructor for cost objective components}
\usage{
constructDobjCostSTRS(X_cost, X_fixed, list)
}
\arguments{
\item{X_cost}{(type: \code{matrix})
A matrix containing stratum- (rows) and type- (columns) specific
cost coefficients associated with fixed cost. Types of cost might be, e.g.
'$ US', 'minutes', 'sample size', etc.}

\item{X_fixed}{(type: \code{matrix})
A matrix containing stratum- (rows) and type- (columns) specific
cost coefficients associated with fixed cost.}

\item{list}{(type: \code{list})
A list of lists taking subpopulation- (domain/area) specific arguments.
Elements are lists containing the following components corresponding
to one specific cost type:
\cr \code{..$stratum_id} (type: \code{numeric})
A vector containing the indices of the strata considered for the current
objective. The indices must coincide with the row numbers of \code{X_cost}.
\cr \code{..$c_type} (type: \code{character} or \code{numeric})
The column name or column index of \code{X_cost} to be addressed.
\cr \code{..$name} (type: \code{character})
The name of the subpopulation (domain/area).}
}
\value{
The function \code{constructDobjCostSTRS()} returns a list containing

\code{$D} (type: \code{matrix}): the cost coefficient matrix for
cost objectives and

\code{$d} (type: \code{vector}): the vector of fixed costs
\cr usable as input to the multiobjective allocation function
\code{mosalloc()}.
}
\description{
A helper function for generating cost matrix \code{D} and
fixed cost vector \code{d} under stratified random sampling (STRS) as
input to the multiobjective allocation function \code{mosalloc()}.
}
\examples{
# Assume we are given two regions stratified into three strata each. We now
# might balance the cost of surveying between both regions.

# Stratum-specific variable cost
ch <- c(25, 40, 33, 18, 53, 21)
names(ch) <- c("R1_S1", "R1_S2", "R1_S3",
               "R2_S1", "R2_S2", "R2_S3")

# Stratum-specific fixed cost
cf <- c(55, 50, 55, 50, 55, 50)
names(cf) <- c("R1_S1", "R1_S2", "R1_S3",
               "R2_S1", "R2_S2", "R2_S3")

# The input \code{D} and \code{d} to \code{mosalloc()} can be specified as
# follows:

D <- matrix(c(ch[1:3], rep(0, 6), ch[4:6]), 2, 6, byrow = TRUE)
d <- as.vector(c(sum(cf[1:3]), sum(cf[4:6])))

# Using \code{constructDobjCostSTRS()} this can also be done via

X_cost <- matrix(ch, ncol = 1)
colnames(X_cost) <- "$ US"

X_fixed <- matrix(cf, ncol = 1)
colnames(X_fixed) <- "$ US"

list <- list(list(stratum_id = 1:3, c_type = "$ US", name = "R1"),
             list(stratum_id = 4:6, c_type = "$ US", name = "R2"))
Dc <- constructDobjCostSTRS(X_cost, X_fixed, list)

# Evaluation of the output
Dc$D - D
Dc$d - d

}
