% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MATESmain.R
\name{optimalwithrank_curnode}
\alias{optimalwithrank_curnode}
\title{This function is used in 'P_Knear_rank'
#' Compute k-rNNG graph}
\usage{
optimalwithrank_curnode(k, cur_neis, neighbor, degree, lambda, rowrank)
}
\arguments{
\item{k}{Integer; desired number of neighbors (out-degree) for the current node}

\item{cur_neis}{Integer vector of current neighbors of the node}

\item{neighbor}{Integer vector of candidate neighbor indices for this node,}

\item{degree}{Numeric vector of current degrees for all nodes}

\item{lambda}{A numeric representing the penalty parameter}

\item{rowrank}{Numeric vector of rank-based penalties for this node}
}
\value{
A list with two elements:
\describe{
\item{new_neis}{Integer vector of length \code{k} giving the updated
neighbors of the node.}
\item{degree}{Updated numeric degree vector for all nodes.}
}
}
\description{
This function builds one-step neighbor update for penalized K nearest neighbor graphs with rank
The output is a list containing the graph and the degree distribution
}
\references{
Zhu, Y., & Chen, H. (2023). A new robust graph for graph-based methods. \emph{arXiv preprint arXiv:2307.15205.}
}
