% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{extract_gaps}
\alias{extract_gaps}
\title{Extract gap episodes from the data}
\usage{
extract_gaps(
  dataset,
  Variable.colname = NULL,
  Datetime.colname = Datetime,
  epoch = "dominant.epoch",
  full.days = TRUE,
  include.implicit.gaps = TRUE
)
}
\arguments{
\item{dataset}{A light logger dataset. Needs to be a dataframe.}

\item{Variable.colname}{Column name of the variable to check for NA values.
Expects a symbol or NULL (only implicit gaps).}

\item{Datetime.colname}{The column that contains the datetime. Needs to be a
\code{POSIXct} and part of the dataset.}

\item{epoch}{The epoch to use for the gapless sequence. Can be either a
\code{lubridate::duration()} or a string. If it is a string, it needs to be
either '"dominant.epoch"' (the default) for a guess based on the data or a
valid \code{lubridate::duration()} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{full.days}{If \code{TRUE}, the gapless sequence will include the whole first
and last day where there is data.}

\item{include.implicit.gaps}{Logical. Whether to expand the datetime sequence
and search for implicit gaps, or not. Default is \code{TRUE}. If no
\code{Variable.colname} is provided, this argument will be ignored. \strong{If there
are implicit gaps, gap calculation can be incorrect whenever there are
missing explicit gaps flanking implicit gaps!}}
}
\value{
A dataframe containing gap times per grouping variable
}
\description{
Finds and extracts gap episodes from a dataset. If no variable is provided,
it will look for implicit gaps (gaps in the regular interval), if a variable
is provided, it will look for implicit and explicit gaps (NA in the variable)
}
\examples{
#removing some data to create gaps
sample.data.environment |> 
 dplyr::filter(MEDI <= 50000) |> 
 extract_gaps() |> head()

#not searching for implicit gaps
sample.data.environment |> 
  dplyr::filter(MEDI <= 50000) |> 
 extract_gaps(MEDI, include.implicit.gaps = FALSE)

#making implicit gaps explicit changes the summary
sample.data.environment |> 
  dplyr::filter(MEDI <= 50000) |> 
  gap_handler()|> 
  extract_gaps(MEDI, include.implicit.gaps = FALSE) |> head()
}
\seealso{
Other regularize: 
\code{\link{dominant_epoch}()},
\code{\link{gap_finder}()},
\code{\link{gap_handler}()},
\code{\link{gapless_Datetimes}()},
\code{\link{has_gaps}()},
\code{\link{has_irregulars}()}
}
\concept{regularize}
