% Generated by roxygen2: do not edit by hand
\name{kwela_analyze}
\alias{kwela_analyze}
\title{KWELA Main Analysis Function}
\usage{
kwela_analyze(
  data,
  pc_pattern = "\\\\bPositive\\\\s*Control\\\\b|^POS\\\\b|\\\\bPC\\\\b",
  nc_pattern = "\\\\bNegative\\\\s*Control\\\\b|^NEG\\\\b|\\\\bNC\\\\b|\\\\bTDB\\\\b|\\\\bBlank\\\\b",
  spiked_pattern = "\\\\+\\\\s*Pos|Pos\\\\s*\\\\d*\%|spiked|\\\\+\\\\s*CWD",
  profile = c("auto", "standard", "sensitive", "matrix_robust"),
  consensus = c("majority", "strict", "flexible", "threshold"),
  consensus_threshold = 0.5,
  matrix_groups = NULL,
  use_raf = TRUE,
  mode = c("diagnostic", "research"),
  instability_check = TRUE,
  instability_strictness = c("moderate", "strict", "lenient"),
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame with Treatment, TTT, MP columns (RAF optional)}

\item{pc_pattern}{Regex for positive controls}

\item{nc_pattern}{Regex for negative controls}

\item{spiked_pattern}{Regex for spiked samples}

\item{profile}{Classification profile: "auto", "standard", "sensitive",
or "matrix_robust". "auto" selects based on separation quality.}

\item{consensus}{Replicate consensus rule: "majority", "strict",
"flexible", or "threshold"}

\item{consensus_threshold}{For "threshold" consensus: minimum mean
well score to classify treatment as positive (default 0.5)}

\item{matrix_groups}{Optional: column name for matrix grouping
(enables per-group baseline correction). NULL = global baselines.}

\item{use_raf}{Logical: include RAF in scoring (default TRUE if present)}

\item{mode}{"diagnostic" (deterministic, no stochastic rescue) or
"research" (full adaptive architecture). Default: "diagnostic".}

\item{instability_check}{Logical: run instability detection (default TRUE)}

\item{instability_strictness}{"moderate" (2+ flags), "strict" (1+),
or "lenient" (3+). Controls override sensitivity.}

\item{verbose}{Print progress}
}
\value{
Data frame with per-well results including:
\describe{
  \item{Type}{Well type: "PC", "NC", or "Sample"}
  \item{is_spiked}{Logical indicating if sample is spiked}
  \item{crossed_threshold}{Logical for TTT threshold crossing}
  \item{has_signal}{Logical for signal above NC threshold}
  \item{hard_gate_pass}{Logical for Layer 1 gate passage}
  \item{artifact_flag}{Logical for suspected artifacts}
  \item{stoch_rescue}{Logical for stochastic rescue (research mode only)}
  \item{ttt_score}{TTT component score (0-1)}
  \item{signal_score}{Signal component score (0-1)}
  \item{raf_score}{RAF component score (0-1, if available)}
  \item{stoch_score}{Stochastic component score (0-1)}
  \item{well_score}{Combined well score (0-1)}
  \item{well_positive}{Logical for well-level positive classification}
  \item{seed_score}{Alias for well_score}
  \item{classification}{Well classification: "POSITIVE", "NEGATIVE", "INCONCLUSIVE", "ARTIFACT_SUSPECT", or "INVALID"}
  \item{confidence}{Confidence level: "VERY_HIGH", "HIGH", "MODERATE", "LOW", or "CONTROL"}
  \item{trt_classification}{Treatment-level consensus classification (may be "INCONCLUSIVE_MATRIX_EFFECT" if instability detected)}
  \item{trt_confidence}{Treatment-level confidence}
  \item{trt_positive_rate}{Fraction of positive wells in treatment}
  \item{trt_mean_score}{Mean well score for treatment}
  \item{matrix_instability}{Logical for Layer 6 instability override}
}

Plus attributes: pc_stats, nc_stats, separation, profile, consensus,
optimal_cutoff, youden_j, thresholds, trt_summary, control_check,
score_semantics, version, mode, instability_check, instability_strictness,
instability_summary, group_controls, group_profiles, group_separation.
}
\description{
Implements hierarchical adaptive classification for 'RT-QuIC' data:
\describe{
  \item{Layer 1: Hard Gate}{Biological constraint filter}
  \item{Layer 2: Per-Well Scoring}{Profile-dependent transforms}
  \item{Layer 3: Adaptive Combination}{Separation-aware combiner}
  \item{Layer 4: Adaptive Cutoff}{Youden-optimized threshold}
  \item{Layer 5: Replicate Consensus}{Treatment-level classification}
  \item{Layer 6: Instability Detection}{Matrix interference override}
}
}
\examples{
\donttest{
set.seed(42)
df <- data.frame(
  Treatment = c(rep("Positive Control", 8), rep("Negative Control", 8),
                rep("Sample_A", 8)),
  TTT = c(rnorm(8, 8, 1), rnorm(8, 72, 5), rnorm(8, 12, 3)),
  MP = c(rnorm(8, 100, 10), rnorm(8, 20, 5), rnorm(8, 85, 15))
)
result <- kwela_analyze(df)
summary <- kwela_summarize(result)
}
}
