% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instability.R
\name{compute_instability_flags}
\alias{compute_instability_flags}
\title{Compute Instability Flags for a Treatment}
\usage{
compute_instability_flags(
  trt_mp,
  trt_ttt,
  pc_mp,
  nc_mp,
  pc_ttt,
  nc_ttt,
  trt_raf = NULL,
  trt_mp_raf = NULL,
  pc_raf_mp_ratios = NULL,
  crossing_threshold = NA_real_,
  strictness = "moderate",
  has_raf = FALSE
)
}
\arguments{
\item{trt_mp}{Finite MP values for treatment wells}

\item{trt_ttt}{TTT values for treatment wells (may contain NA/Inf)}

\item{pc_mp, nc_mp}{Positive/negative control MP values (finite)}

\item{pc_ttt, nc_ttt}{Positive/negative control TTT values}

\item{trt_raf}{RAF values for treatment wells (NULL if unavailable)}

\item{trt_mp_raf}{MP values corresponding to RAF wells (NULL if unavailable)}

\item{pc_raf_mp_ratios}{RAF/MP ratios from positive controls (NULL if unavailable)}

\item{crossing_threshold}{TTT crossing threshold for this treatment's group}

\item{strictness}{"moderate" (2+ flags), "strict" (1+), or "lenient" (3+)}

\item{has_raf}{Whether RAF data is available}
}
\value{
List with components: \code{unstable} (logical), \code{reasons}
(character vector), \code{n_flags} (integer), \code{min_flags_required}
(integer), \code{metrics} (named list).
}
\description{
Evaluates 6 deterministic metrics to detect matrix interference that
compromises classification reliability. A treatment is flagged as unstable
when it behaves unlike both positive and negative controls.
}
\details{
The six metrics evaluated are:
\enumerate{
  \item Fano factor deviation from positive controls

  \item Crossing variability (ambiguous threshold crossing rate)
  \item Wasserstein distance from BOTH controls (normalized by NC spread)
  \item Energy distance from BOTH controls (normalized by NC spread)
  \item TTT dispersion ratio vs positive controls
  \item RAF-MP ratio inconsistency vs positive controls
}

All metrics are deterministic (no random number generation).
}
\examples{
set.seed(42)
flags <- compute_instability_flags(
  trt_mp = rnorm(8, 50, 20),
  trt_ttt = rnorm(8, 40, 15),
  pc_mp = rnorm(8, 100, 10),
  nc_mp = rnorm(8, 20, 5),
  pc_ttt = rnorm(8, 8, 1),
  nc_ttt = rnorm(8, 72, 5),
  crossing_threshold = 40,
  strictness = "moderate"
)
}
