% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicates.R
\name{get_replicate_list_sd}
\alias{get_replicate_list_sd}
\title{Get replicates sd}
\usage{
get_replicate_list_sd(
  dat,
  protein = dat[["Protein"]][1],
  state = dat[["State"]][1],
  time_t = unique(dat[["Exposure"]])[3]
)
}
\arguments{
\item{dat}{data as imported by the \code{\link{read_hdx}} function.}

\item{protein}{chosen protein.}

\item{state}{biological state for chosen protein.}

\item{time_t}{time point of the measurement.}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Get list of peptides with their standard
deviation.
}
\details{
Function gets the pepitde list 
in selected state with their standard deviation
of measurement, calculated from the technical 
replicates. It is used for selection for
measurement variability plot.
}
\examples{
get_replicate_list_sd(alpha_dat)


}
\seealso{
\code{\link{create_replicate_dataset}}
}
