% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{create_overlap_distribution_dataset}
\alias{create_overlap_distribution_dataset}
\title{Show overlap distribution data}
\usage{
create_overlap_distribution_dataset(
  dat,
  protein = dat[["Protein"]][1],
  state = dat[["State"]][1],
  start = min(dat[["Start"]]),
  end = max(dat[["End"]]),
  protein_sequence = reconstruct_sequence(dat)
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function.}

\item{protein}{chosen protein.}

\item{state}{biological state for chosen protein.}

\item{start}{start position of chosen protein.}

\item{end}{end position of chosen protein.}

\item{protein_sequence}{data produced by 
\code{\link{reconstruct_sequence}} function.}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Generates the data of frequency of overlap of
each amino in the protein sequence.
}
\details{
This data frame presents how many times (by how many peptides) 
a amino position in protein sequence is covered. 
This data is available in the GUI.
}
\examples{
create_overlap_distribution_dataset(alpha_dat)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{reconstruct_sequence}}
}
