% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_peptide_kinetics.R
\name{calculate_peptide_kinetics}
\alias{calculate_peptide_kinetics}
\title{Calculate kinetics dataset}
\usage{
calculate_peptide_kinetics(
  dat,
  protein = dat[["Protein"]][1],
  sequence = dat[["Sequence"]][1],
  states = unique(dat[["State"]]),
  start = dat[["Start"]][1],
  end = dat[["End"]][1],
  time_0 = min(dat[["Exposure"]]),
  time_100 = max(dat[["Exposure"]]),
  deut_part = 0.9
)
}
\arguments{
\item{dat}{dat data imported by the \code{\link{read_hdx}} function.}

\item{protein}{chosen protein.}

\item{sequence}{sequence of chosen peptide.}

\item{states}{vector of states (for chosen protein), for which the 
calculations are done.}

\item{start}{start position of chosen peptide.}

\item{end}{end position of chosen peptide.}

\item{time_0}{minimal exchange control time point of measurement.}

\item{time_100}{maximal exchange control time point of measurement.}

\item{deut_part}{deuterium percentage in solution used in experiment, 
value from range [0, 1].}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Calculate kinetics of the hydrogen-deuteration exchange 
for given peptide in multiple biological states.
}
\details{
Function \code{\link{calculate_peptide_kinetics}} calculates
kinetic data for chosen peptide in chosen biological states.
It is a wrapper for \code{\link{calculate_kinetics}} but for multiple
states.
The output of this function can be visualized using \code{\link{plot_uptake_curve}}.
IMPORTANT! The kinetic data is often described as deuterium uptake curve data. 
We use this terms interchangeable.
}
\examples{
# by default calculated for the first peptide from the peptide pool
calculate_peptide_kinetics(alpha_dat)

}
\seealso{
\code{\link{calculate_kinetics}}
\code{\link{calculate_state_uptake}}
\code{\link{plot_uptake_curve}}
}
