% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HFDutils.R
\name{HFCparse}
\alias{HFCparse}
\title{HFCparse internal function for modifying freshly read HCD data in its standard form}
\usage{
HFCparse(DF)
}
\arguments{
\item{DF}{a data.frame of HFC data, freshly read in.}
}
\value{
DF same data.frame, modified so that columns are of a useful class. If there were open age categories, such as \code{"-"} or \code{"+"}, this information is stored in a new dummy column called \code{OpenInterval}. Values of 99 or -99 in the \code{AgeInterval} column are replaced with \code{"+"} and \code{"-"}, respectively. \code{Year} taken from \code{Year1}, and \code{YearInterval} is given, rather than \code{Year2}. Users wishing for a central time point should bear this is mind. The column \code{Country} is renamed \code{CNTRY}. Otherwise, columns in this database are kept in the \code{data.frame}, in case they may be useful.
}
\description{
called by \code{readHFC()} and \code{readHFCweb()}. We assume there are no factors in the given data.frame and that it has been read in from the raw text files using something like: \code{ read.csv(file = filepath, stringsAsFactors = FALSE, na.strings = ".", strip.white = TRUE)}. This function is visible to users, but is not likely needed directly.
}
\details{
This parse routine is based on the subjective opinions of the author...
}
