% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{surrogate}
\alias{surrogate}
\title{Find surrogate GEV parameters for model-averaged quantiles}
\usage{
surrogate(zpf.surr = NULL, xqa, init.surr)
}
\arguments{
\item{zpf.surr}{Numeric vector of model-averaged quantiles at \code{xqa}.}

\item{xqa}{Numeric vector of probabilities at which quantiles are evaluated.}

\item{init.surr}{Initial GEV parameter estimates for optimization.}
}
\value{
A list (from \code{optim()}) with additional components:
\describe{
  \item{par}{Surrogate GEV parameters (mu, sigma, xi)}
  \item{zp.surrmodel}{Quantiles from the surrogate model at \code{xqa}}
  \item{zp.MA}{The input model-averaged quantiles}
}
}
\description{
Internal function that fits a single GEV distribution to
the model-averaged quantile curve, producing surrogate GEV parameters
that approximate the model-averaged quantile function.
}
\keyword{internal}
