% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev11.R
\name{make.qmax.gev11}
\alias{make.qmax.gev11}
\title{Create maximum residual series for GEV11 model}
\usage{
make.qmax.gev11(xdat = NULL, orig.para = NULL, rob = NULL)
}
\arguments{
\item{xdat}{Numeric vector of data.}

\item{orig.para}{Initial parameter vector (mu0, mu1, sigma0, sigma1, xi).}

\item{rob}{Logical. If TRUE, use robust regression. If FALSE, use OLS.}
}
\value{
A list containing:
\describe{
  \item{qmax}{Modified residual series (numeric vector)}
  \item{sig0}{Log-scale intercept estimate}
  \item{sig1}{Log-scale trend estimate}
}
}
\description{
Internal function that constructs a modified residual series
(qmax) from the data after removing estimated location trend, used for
the GN16 time-varying moment method.
}
\keyword{internal}
