% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{gev.rl.delta}
\alias{gev.rl.delta}
\title{MLE with return level and delta method SE}
\usage{
gev.rl.delta(data, ntry = 5, quant)
}
\arguments{
\item{data}{Numeric vector of data.}

\item{ntry}{Number of optimization attempts. Default is 5.}

\item{quant}{Numeric vector of probabilities for quantile estimation.}
}
\value{
A list containing:
\describe{
  \item{nllh}{Negative log-likelihood}
  \item{mle}{MLE estimates (mu, sigma, xi) in Hosking style}
  \item{qua.mle}{Quantile estimates at \code{quant} probabilities}
  \item{data}{Input data}
  \item{cov}{3x3 covariance matrix from MLE}
  \item{quant}{Input quantile probabilities}
}
}
\description{
Internal function that computes GEV MLE using both
constrained optimization (solnp) and ismev::gev.fit, selects the
better fit, and returns the covariance matrix for delta method SE.
}
\keyword{internal}
