% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{match_score}
\alias{match_score}
\title{Match score between query and reference neighbourhoods}
\usage{
match_score(
  integrated,
  ref = "10X",
  query = "SS2",
  label_key = "annotation",
  emb_key = "pca",
  batch_key = "dataset",
  k = 10,
  seed = NULL
)
}
\arguments{
\item{integrated}{\link[Seurat]{Seurat} object containing the joint embedding
and meta-data.}

\item{ref}{Name of the reference dataset/batch (default \code{"10X"}).}

\item{query}{Name of the query dataset/batch (default \code{"SS2"}).}

\item{label_key}{Name of the meta-data column that stores cell-type / label
information (default \code{"annotation"}).}

\item{emb_key}{Name of the reduction to use (default \code{"pca"}).}

\item{batch_key}{Name of the meta-data column that indicates dataset/batch
origin (default \code{"dataset"}).}

\item{k}{Number of nearest neighbours to consider (default \code{10}).}

\item{seed}{Integer, random seed for reproducibility (optional). If NULL, uses current random state.}
}
\value{
Named numeric vector of length equal to the number of query cells.
}
\description{
Compute, for each query cell, the ratio of the average within-query distance
to the average query-to-reference distance in the integrated PCA space.
Smaller values imply better alignment.
}
