% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainer_var_test.R
\name{trainer_var_test}
\alias{trainer_var_test}
\title{Interpret an F test comparing two variances (var.test) with an audience-aware LLM prompt}
\usage{
trainer_var_test(
  vt_obj,
  introduction = NULL,
  alpha = 0.05,
  audience = c("beginner", "applied", "advanced"),
  summary_only = FALSE,
  llm_model = "llama3",
  generate = FALSE
)
}
\arguments{
\item{vt_obj}{An htest object returned by stats::var.test().}

\item{introduction}{Optional character string giving the study context.}

\item{alpha}{Numeric significance level (default 0.05).}

\item{audience}{One of c("beginner","applied","advanced").}

\item{summary_only}{Logical; if TRUE, return a 3-bullet executive summary
regardless of audience depth (uses trainer_core_summary_only_block()).}

\item{llm_model}{Character; model name for the generator (default "llama3").}

\item{generate}{Logical; if TRUE, call the generator and return prompt + response.}
}
\value{
If generate = FALSE, a prompt string. If TRUE, a list with
  prompt, response, and model.
}
\description{
Builds a clear, audience-tailored prompt to interpret a base R stats::var.test() result.
}
\examples{
set.seed(1)
x <- rnorm(25, sd = 1.0); y <- rnorm(30, sd = 1.3)
vt <- var.test(x, y)
cat(trainer_var_test(vt, audience = "applied"))
cat(trainer_var_test(vt, audience = "advanced", summary_only = TRUE))
}
