ExplicitExploration <- function(fun,lower,upper,n = 30,
                                maxiter,k = 5,
                                tolerance = 0.01,...){
  dim_par <- length(lower)
  error <- 1e10
  P <- mapply(runif, lower, upper, MoreArgs = list(n = n))
  Y <- apply(P, 1, fun,...)
  G <- 0
  n_gen <- 1
  historical <- c(min(Y))
  while (G < k & n_gen < maxiter) {
    Q <- mapply(runif, lower, upper, MoreArgs = list(n = n))
    Z <- apply(Q, 1, fun,...)
    historical <- c(historical,min(Z))
    P <- rbind(P,Q)
    error <- comparison(x = Y, y = c(Y,Z))
    Y <- c(Y,Z)
    n_gen <- n_gen + 1
    if(error > tolerance){
      G <- 0
    }else{
      G <- G + 1
    }
  }
  best_par <- P[order(Y)[1:n],]
  best_par <- matrix(best_par, ncol = dim_par)
  return(list(par = best_par, Y = Y,n_gen = n_gen,
              par_historical = P,
              historical = historical))
}
