% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgwt_core.R
\name{compute_sgwt_filters}
\alias{compute_sgwt_filters}
\title{Compute SGWT filters}
\usage{
compute_sgwt_filters(eigenvalues, scales, lmax = NULL, kernel_type = "heat")
}
\arguments{
\item{eigenvalues}{Eigenvalues of the graph Laplacian}

\item{scales}{Vector of scales for the wavelets}

\item{lmax}{Maximum eigenvalue (optional)}

\item{kernel_type}{Kernel family that defines both scaling and wavelet filters (default: "mexican_hat", options: "mexican_hat", "meyer", "heat")}
}
\value{
List of filters (scaling function + wavelets)
}
\description{
Compute wavelet and scaling function coefficients in the spectral domain
}
\examples{
eigenvals <- c(0, 0.1, 0.5, 1.0, 1.5)
scales <- c(2, 1, 0.5)
filters <- compute_sgwt_filters(eigenvals, scales)
filters_meyer <- compute_sgwt_filters(eigenvals, scales, kernel_type = "meyer")
filters_heat <- compute_sgwt_filters(eigenvals, scales, kernel_type = "heat")
}
