% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{getModelFits}
\alias{getModelFits}
\title{getModelFits}
\usage{
getModelFits(
  models,
  dose_levels,
  posterior,
  avg_fit = TRUE,
  simple = FALSE,
  probability_scale = FALSE
)
}
\arguments{
\item{models}{A Mods object as created with \code{DoseFinding::Mods()} or a vector
of model names for which a fit will be performed.
Implemented model shapes are \code{"linear"}, \code{"exponential"}, \code{"logistic"},
\code{"emax"}, \code{"sigEmax"}, \code{"quadratic"}, and \code{"betaMod"}.}

\item{dose_levels}{A vector containing the different dosage levels.}

\item{posterior}{A getPosterior object, containing the (multivariate) posterior distribution per dosage level.}

\item{avg_fit}{Boolean variable, defining whether an average fit (based on generalized AIC weights) should be performed in addition to the individual models. Default TRUE.}

\item{simple}{Boolean variable, defining whether simplified fit will be applied. Default FALSE.}

\item{probability_scale}{A boolean variable to specify if the predicted dose-response should be on the logit scale or the probability scale. Setting to TRUE will transform predictions from the logit scale to the probability scale, which can be desirable for a binary outcome. Default FALSE.}
}
\value{
An object of class modelFits. A list containing information about the fitted model coefficients, the prediction per dose group as well as maximum effect and generalized AIC (and corresponding weight) per model.
}
\description{
Fits dose-response curves for the specified dose-response models, based on the posterior distributions.
For the simplified fit, multivariate normal distributions will be approximated and reduced by one-dimensional normal distributions.
For the default case, the Nelder-Mead algorithm is used.
In detail, for both approaches the mean vector \eqn{\theta^{Y}} and the covariance \eqn{\Sigma} of the (mixture) posterior distributions and the corresponding posterior weights \eqn{\tilde{\omega}_{l}} for \eqn{l \in {1,...,L}} are used as basis
For the full fit a GLS estimator is used to minimize the following expression for the respective dose-response models \eqn{m}
\deqn{ \hat{\theta}_{m}=\text{arg min}_{\theta_{m}} \sum_{l=1}^{L} \tilde{\omega}_{l}(\theta_{l_{i}}^{Y}-f(dose_{i},\hat{\theta}_{m}))'\Sigma_{l}^{-1}(\theta_{l_{i}}^{Y}-f(dose_{i},\hat{\theta}_{m}))}
Therefore the function nloptr of the nloptr package is utilized.
In the simplified case \eqn{L=1}, as the dimension of the posterior is reduced to 1 first.
The generalized AIC values are calculated via the formula
\deqn{gAIC_{m} = \sum_{l=1}^{L} \tilde{\omega}_{l} \sum_{i=0}^{K} \frac{1}{\Sigma_{l_{i,i}}} (\theta_{l_i}^Y - f(dose_{i},\hat{\theta}_{m}))^2 + 2p }
where \eqn{p} denotes the number of estimated parameters and \eqn{K} the number of active dose levels.
Here as well for the simplified case the formula reduces to one summand as \eqn{L=1}.
Corresponding gAIC based weights for model \eqn{M} are calculated as outlined in Schorning et al. (2016)
\deqn{
\Omega_I (M) = \frac{\exp(-0.5 gAIC_{M})}{\sum_{m=1}^{Q} \exp(-0.5 gAIC_{m})}
}
where \eqn{Q} denotes the number of models included in the averaging procedure.
}
\examples{
posterior_list <- list(Ctrl = RBesT::mixnorm(comp1 = c(w = 1, m = 0, s = 1), sigma = 2),
                       DG_1 = RBesT::mixnorm(comp1 = c(w = 1, m = 3, s = 1.2), sigma = 2),
                       DG_2 = RBesT::mixnorm(comp1 = c(w = 1, m = 4, s = 1.5), sigma = 2),
                       DG_3 = RBesT::mixnorm(comp1 = c(w = 1, m = 6, s = 1.2), sigma = 2),
                       DG_4 = RBesT::mixnorm(comp1 = c(w = 1, m = 6.5, s = 1.1), sigma = 2))
models         <- c("emax", "exponential", "sigEmax", "linear")
dose_levels    <- c(0, 1, 2, 4, 8)

fit        <- getModelFits(models      = models,
                           posterior   = posterior_list,
                           dose_levels = dose_levels)
                           
fit
                           
fit_simple <- getModelFits(models      = models,
                           posterior   = posterior_list,
                           dose_levels = dose_levels,
                           simple      = TRUE)
                           
fit_simple

}
\references{
Schorning K, Bornkamp B, Bretz F, Dette H. 2016. Model selection versus model averaging in dose finding studies. Stat Med; 35; 4021-4040.
}
