% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coveff.R
\name{sim_coveff}
\alias{sim_coveff}
\title{Perform simulation of covariate effects for ER model}
\usage{
sim_coveff(
  ermod,
  data = NULL,
  spec_coveff = NULL,
  output_type = "median_qi",
  qi_width = 0.9,
  qi_width_cov = 0.9
)
}
\arguments{
\item{ermod}{an object of class \code{ermod} (supports \code{ermod_bin} and \code{ermod_lin})}

\item{data}{an optional data frame to derive the covariate values for
forest plots. If NULL (default), the data used to fit the model is used.}

\item{spec_coveff}{you can supply spec_coveff to \code{\link[=sim_coveff]{sim_coveff()}} or
\code{\link[=plot_coveff]{plot_coveff()}}, if you have already built it manually or with
\code{\link[=build_spec_coveff]{build_spec_coveff()}}. See \code{\link[=build_spec_coveff]{build_spec_coveff()}} for detail.}

\item{output_type}{Type of output. Currently only supports "median_qi"
which returns the median and quantile interval.}

\item{qi_width}{the width of the credible interval on the covariate effect.
This translate to the width of the error bars in the forest plot.}

\item{qi_width_cov}{the width of the quantile interval for continuous
covariates in the forest plot. Default is 0.9 (i.e. visualize effect of
covariate effect at their 5th and 95th percentile values).}
}
\value{
A data frame with class \code{coveffsim} containing the median and
quantile interval of the covariate effects. For binary models (\code{ermod_bin}),
returns odds ratios. For linear models (\code{ermod_lin}), returns response differences.
}
\description{
Perform simulation of covariate effects for ER model
}
\examples{
\dontshow{if (BayesERtools:::.if_run_ex_coveff()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
data(d_sim_binom_cov_hgly2)

ermod_bin <- dev_ermod_bin(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = "BHBA1C_5",
)

sim_coveff(ermod_bin)

# Linear regression model example
data(d_sim_lin)

ermod_lin <- dev_ermod_lin(
  data = d_sim_lin,
  var_resp = "response",
  var_exposure = "AUCss",
  var_cov = c("SEX", "BAGE"),
)

sim_coveff(ermod_lin)
}
\dontshow{\}) # examplesIf}
}
