% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dztplnm.R
\name{dztplnm}
\alias{dztplnm}
\alias{rztplnm}
\title{The zero-truncated compund poisson-lognormal distributions mixture}
\usage{
dztplnm(x, mu, sig, theta, log = FALSE, type1 = TRUE)

rztplnm(n, mu, sig, theta, type1 = TRUE)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{mu}{vector of mean of lognormal distribution in sample.}

\item{sig}{vector standard deviation of lognormal distribution in sample.}

\item{theta}{vector of mixture weights}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{type1}{logical; if TRUE, Use type 1 ztpln else use type 2.}

\item{n}{number of random values to return.}
}
\value{
dztplnm gives the (log) density and rztplnm generates
random variates.
function, qpois gives the quantile function, and rpois generates random
deviates.
}
\description{
Density function and random generation for Zero-Truncated
Poisson Lognormal distribution with parameters \code{mu}, \code{sig}, and \code{theta}.
}
\details{
Type 1 ZTPLN truncates zero based on Poisson-lognormal distribution and
type 2 ZTPLN truncates zero based on zero-truncated Poisson distribution.
For mathematical details, please see \code{vignette("ztpln")}
}
\examples{
rztplnm(n = 100, mu = c(0, 5), sig = c(1, 2), theta = c(0.2, 0.8))
dztplnm(x = 1:100, mu = c(0, 5), sig = c(1, 2), theta = c(0.2, 0.8))
dztplnm(x = 1:100, mu = c(0, 5), sig = c(1, 2), theta = c(0.2, 0.8), type1 = FALSE)
}
\seealso{
\code{\link{dztpln}}
}
