% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vgmsfh.r
\name{vgmsfh_numpyro}
\alias{vgmsfh_numpyro}
\title{Run VGMSFH Using NumPyro}
\usage{
vgmsfh_numpyro(
  y,
  y_sigma,
  X,
  W,
  GEOID,
  model_name,
  save_dir = NULL,
  num_warmup = 1000,
  num_samples = 1000,
  verbose = TRUE,
  use_gpu = FALSE
)
}
\arguments{
\item{y}{Matrix. Response variables (direct estimates).}

\item{y_sigma}{Matrix. Reported standard deviations of the responses.}

\item{X}{Matrix. Covariate matrix.}

\item{W}{Matrix. Proximity or adjacency matrix defining spatial structure.}

\item{GEOID}{Character vector. FIPS codes or other region identifiers used to match with the pretrained VAE model.}

\item{model_name}{Character. The name of the pretrained VAE model.}

\item{save_dir}{Character. The directory where the VAE model is stored. If \code{NULL}, a default pretrained model directory is used.}

\item{num_warmup}{Integer. Number of warmup (burn-in) iterations. Default is 1000.}

\item{num_samples}{Integer. Number of posterior samples to draw. Default is 1000.}

\item{verbose}{Logical; if \code{TRUE} (default), prints progress.}

\item{use_gpu}{Boolean. Use GPU if available. GPU support is recommended only for high-dimensional datasets (e.g., those with more than 1,000 areas). Default is \code{FALSE}.}
}
\value{
An object of class \code{VGMSFH}, which contains:
\itemize{
\item \code{direct_estimate}: the observed response data,
\item \code{yhat_samples}: posterior samples of the latent population process,
\item \code{phi_samples}: posterior samples of spatial random effects (CAR),
\item \code{beta_samples}: posterior samples of fixed effect coefficients,
\item \code{other_samples}: a list containing all sampled parameters, including \code{mu}, \code{delta}, and other intermediate quantities.
}
}
\description{
This function runs the Variational Generalized Multivariate Spatil Fay-Herriot model (VGMSFH) using NumPyro as the inference backend. It loads pretrained VAE decoder weights, prepares the data, and performs posterior sampling.
}
\details{
This function uses a pretrained VAE decoder to parameterize the CAR prior and enables scalable inference through NumPyro. It is suitable for both univariate and multivariate response modeling in spatial domains.
}
\examples{
\dontrun{
library(sf)
library(vmsae)
# this function is time consuming for the first run
install_environment()
load_environment()

acs_data <- read_sf(system.file("example", "mo_county.shp", package = "vmsae"))
y <- readRDS(system.file("example", "y.Rds", package = "vmsae"))
y_sigma <- readRDS(system.file("example", "y_sigma.Rds", package = "vmsae"))
X <- readRDS(system.file("example", "X.Rds", package = "vmsae"))
W <- readRDS(system.file("example", "W.Rds", package = "vmsae"))

num_samples <- 1000 # set to larger values in practice, e.g. 10000.
model <- vgmsfh_numpyro(y, y_sigma, X, W,
  GEOID = acs_data$GEOID,
  model_name = "mo_county", save_dir = NULL,
  num_samples = num_samples, num_warmup = num_samples)
y_hat_np <- model@yhat_samples
y_hat_mean_np <- apply(y_hat_np, c(2, 3), mean)
y_hat_lower_np <- apply(y_hat_np, c(2, 3), quantile, 0.025)
y_hat_upper_np <- apply(y_hat_np, c(2, 3), quantile, 0.975)

plot(model, shp = acs_data, type = "compare", var_idx = 2)
}

}
\references{
Wang, Z., Parker, P. A., & Holan, S. H. (2025). Variational Autoencoded Multivariate Spatial Fay-Herriot Models. arXiv:2503.14710. \url{https://arxiv.org/abs/2503.14710}
}
