% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_curve3d.R
\name{plot_curve3d}
\alias{plot_curve3d}
\title{Plot a 3D parametric curve with plotly}
\usage{
plot_curve3d(
  data,
  mode = "lines",
  line = list(color = "blue", width = 3, dash = "solid"),
  marker = NULL,
  title = NULL,
  scene = list(xaxis = list(title = "x(t)"), yaxis = list(title = "y(t)"), zaxis =
    list(title = "z(t)")),
  bg = list(paper = "white", plot = "white")
)
}
\arguments{
\item{data}{Tibble with columns \code{t}, \code{x}, \code{y}, \code{z}.}

\item{mode}{Character string. Plotly trace mode, e.g. \code{"lines"} or
\code{"lines+markers"}.}

\item{line}{List with line styling options, such as
\code{list(color = "blue", width = 3, dash = "solid")}.}

\item{marker}{Optional list with marker styling options, or \code{NULL}
to omit markers.}

\item{title}{Optional character string for the plot title.}

\item{scene}{List specifying 3D axis titles and options, passed to
\code{plotly::layout()}, typically including \code{xaxis}, \code{yaxis},
and \code{zaxis}.}

\item{bg}{List with background colors, e.g.
\code{list(paper = "white", plot = "white")}.}
}
\value{
A \pkg{plotly} object, which is printed for interactive visualization.
}
\description{
Creates an interactive 3D plot of a parametric curve given
a tibble with columns \code{t}, \code{x}, \code{y}, \code{z}
(typically produced by \code{\link[=curve_sample3d]{curve_sample3d()}}).
}
\details{
This function requires the \pkg{plotly} package to be installed.
}
\examples{
data <- curve_sample3d(
  function(t) 2 * cos(t),
  function(t) 3 * sin(t),
  function(t) t / 5,
  0, 2 * pi, 100
)
\donttest{
if (requireNamespace("plotly", quietly = TRUE)) {
  plot_curve3d(data, line = list(color = "red", width = 4))
}
}

}
\seealso{
\code{\link[=curve_sample3d]{curve_sample3d()}}, \code{\link[=arc_length3d]{arc_length3d()}}
}
