% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_gps.R
\name{run_selected_matching}
\alias{run_selected_matching}
\title{Rerun GPS Estimation and Matching for a Selected Configuration}
\usage{
run_selected_matching(x, data, formula, smd_group = NULL, row = 1L, ...)
}
\arguments{
\item{x}{A \code{select_result} object returned by \code{select_opt()}.}

\item{data}{Data frame used in the original optimization (pass it the same
way as in your original analysis, e.g. \code{data = cancer}).}

\item{formula}{Model formula used for GPS estimation (e.g.
\code{formula_cancer}).}

\item{smd_group}{Optional SMD bin to filter on
(e.g. \code{"0.10-0.15"}). If \code{NULL}, no filtering is applied.}

\item{row}{Integer index of the row (after optional filtering by
\code{smd_group}) to use. Defaults to \code{1}.}

\item{...}{Extra args forwarded to \code{match_gps()}.}
}
\value{
The result of \code{match_gps()}.
}
\description{
Rerun GPS Estimation and Matching for a Selected Configuration
}
\examples{
\donttest{
# Define formula and set up optimization
formula_cancer <- formula(status ~ age * sex)
opt_args <- make_opt_args(cancer, formula_cancer, gps_method = "m1")
withr::with_seed(8252, {
  opt_results <- optimize_gps(
    data = cancer,
    formula = formula_cancer,
    opt_args = opt_args,
    n_iter = 2000
  )
})
# Select optimal combinations prioritizing SMD balance and matching in key
# groups
select_results <- select_opt(
  x = opt_results,
  smd_groups = list(
    c("adenoma", "control"),
    c("control", "crc_benign"),
    c("crc_malignant", "control")
  ),
  smd_variables = "age",
  smd_type = "max",
  perc_matched = c("adenoma", "crc_malignant")
)

# Extract the parameter grid from select_results for smd_group = "0.05-0.10"
get_select_params(select_results, smd_group = "0.05-0.10")

# Rerun the analysis
}
}
