% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Detergent}
\alias{Detergent}
\title{Detergent Preference Data}
\format{
A 4-dimensional array resulting from cross-tabulating 4 variables
for 1008 observations. The variable names and their levels are:

\tabular{rll}{
dim \tab Name \tab Levels \cr
1\tab \code{Temperature}\tab \verb{"High", "Low"}\cr
2\tab \code{M_User}\tab \verb{"Yes", "No"}\cr
3\tab \code{Preference}\tab \verb{"Brand X", "Brand M"}\cr
4\tab \code{Water_softness}\tab \verb{"Soft", "Medium", "Hard"}\cr
}
}
\source{
Fienberg, S. E. (1980). \emph{The Analysis of
Cross-Classified Categorical Data} Cambridge, MA: MIT Press, p. 71.
}
\description{
Cross-classification of a sample of 1008 consumers according to (a) the
softness of the laundry water used, (b) previous use of detergent Brand M,
(c) the temperature of laundry water used and (d) expressed preference for
Brand X or Brand M in a blind trial.
}
\examples{

data(Detergent)

# basic mosaic plot
mosaic(Detergent, shade=TRUE)

require(MASS)
(det.mod0 <- loglm(~ Preference + Temperature + M_User + Water_softness,
                   data=Detergent))
# examine addition of two-way terms
add1(det.mod0, ~ .^2, test="Chisq")

# model for Preference as a response
(det.mod1 <- loglm(~ Preference + (Temperature * M_User * Water_softness),
                   data=Detergent))
mosaic(det.mod0)



}
\references{
Ries, P. N. & Smith, H. (1963). The use of
chi-square for preference testing in multidimensional problems.
\emph{Chemical Engineering Progress}, 59, 39-43.
}
\keyword{datasets}
