varoc3d=function(y,x,zlim=NULL,plot=TRUE,digits=2,pval="no",B=2000){

  fit=tmd_ft(y=y,x=x,pval="no")

  if(plot==TRUE){
    legend="top"
    cex.main=1
    cex=1
    cex.axis=1
    cex.lab=1
    cex.legend=1
    Alpha=0.9
    main="VAROC"
    ylab="TPF"
    xlab="FPF"
    zlab="TMD"
    clab="TMD"

    if(is.null(zlim)){
      tmd.min=tmd.max=NULL
    }else{
      tmd.min=zlim[1]
      tmd.max=zlim[2]
    }

    #1.data
    tmd=fit$res1$tmd
    tpf=fit$res1$tpf
    fpf=fit$res1$fpf
    M=length(tmd)

    auc=fit$res2$auc
    itmd=fit$res2$itmd

    tmd.title="TMD"
    itmd.title="ITMD="

    #2. tmd range
    tmd.min0=min(tmd,na.rm=TRUE)
    tmd.max0=max(tmd,na.rm=TRUE)

    if(is.null(tmd.min)){
      tmd.min=tmd.min0
    }else{
      tmd.min=min(tmd.min,tmd.min0)
    }
    if(is.null(tmd.max)){
      tmd.max=tmd.max0
    }else{
      tmd.max=max(tmd.max,tmd.max0)
    }
    tmd.range=c(tmd.min,tmd.max)

    #3.plot
    x = fpf
    y = tpf
    z = tmd

    #3.1 surface
    grid.point = 21
    x.pred = seq(0, 1, length.out = grid.point)
    y.pred = seq(0, 1, length.out = grid.point)
    z.pred=matrix(0,grid.point,grid.point)
    #fitpoints=rep(0,length(x))

    #3.2. blank plat due to clim
    x1=c(0,1)
    y1=c(0,1)
    z1=range(tmd.range)
    theta = 45
    phi = 30
    surf_value=0
    scatter3D(x=x1,y=y1,z=z1,pch=" ",type='p',ticktype = "detailed",xlab = "",ylab = "",zlab="",clab=clab, theta=theta,phi=phi,main=main,alpha=0)

    #3.3. right-continuous by x
    m=100
    x2=seq(0,1,length.out=m)
    y2=z2=rep(NA,m)
    for(i in 1:m){
      z2[i]=z[which(x<=x2[i])[1]]
      y2[i]=y[which(x<=x2[i])[1]]
    }
    x2=c(0,x2)
    y2=c(0,y2)
    z2=c(z2[1],z2)

    #3.4. upper-continuous by y
    y3=seq(0,1,length.out=m)
    x3=z3=rep(NA,m)
    for(i in 1:m){
      z3[i]=z[tail(which(y>=y3[i]),1)]
      x3[i]=x[tail(which(y>=y3[i]),1)]
    }
    x3=c(x3,1)
    y3=c(y3,1)
    z3=c(z3,tail(z3,1))

    #3.5. add plots
    df4=data.frame(x4=c(x2,x3),y4=c(y2,y3),z4=c(z2,z3)) #faster
    df4=df4[!duplicated(df4),]
    x4=df4$x4
    y4=df4$y4
    z4=df4$z4

    fitpoints4=rep(surf_value,length(x4))
    plot3D::scatter3D(x=x4,y=y4,z=z4,pch = " ",cex=cex,covar=z2,theta = theta, phi = phi, ticktype = "detailed",xlab = "", ylab = "", zlab="",clab="",clim=tmd.range,main = "",add=TRUE,
                      surf = list(x = x.pred, y = y.pred, z = z.pred, facets = NA, fit = fitpoints4, border="black"),colkey=TRUE,alpha=Alpha)


    text(-0.3, -0.4,xlab,adj=0,srt=-45)
    text( 0.25, -0.45,ylab,adj=0,srt=45)
    text(-0.47, 0.3,zlab,adj=0,srt=10)

    AUC.text=paste0("AUC=",format(round(auc,digits),nsmall=digits))
    ITMD.text=paste0(itmd.title,format(round(itmd,digits),nsmall=digits))
    graphics::legend(legend,paste0(AUC.text,"\n",ITMD.text),adj=0,cex=cex.legend,bty='n')
  }

  return(fit)
}







