% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_match_static.R
\name{static_match}
\alias{static_match}
\title{Static Matching}
\usage{
static_match(
  data_set,
  outcome_date_col,
  censoring_date_col,
  immunization_date_col,
  vacc_status_col,
  vaccinated_status,
  unvaccinated_status,
  start_cohort,
  end_cohort,
  nearest,
  exact
)
}
\arguments{
\item{data_set}{\code{data.frame} with cohort information.}

\item{outcome_date_col}{Name of the column that contains the outcome dates.}

\item{censoring_date_col}{Name of the column that contains the censoring
date.}

\item{immunization_date_col}{Name of the column that contains the
immunization date to set the beginning of the follow-up period
(\code{t0_follow_up}).}

\item{vacc_status_col}{Name of the column containing the vaccination.}

\item{vaccinated_status}{Status assigned to the vaccinated population.}

\item{unvaccinated_status}{Status assigned to the unvaccinated population.}

\item{start_cohort}{Start date of the study.}

\item{end_cohort}{End date of the study.}

\item{nearest}{Named vector with name(s) of column(s) for \code{nearest} matching
and caliper(s) for each variable (e.g., \code{nearest = c("characteristic1" = n1, "characteristic2" = n2)}, where \code{n1} and \code{n2} are the calipers).}

\item{exact}{Name(s) of column(s) for \code{exact} matching}
}
\value{
List with results from static match:
\code{match}: adjusted cohort, \code{summary}: matching summary,
\code{balance_all}: balance of the cohort before matching,
\code{balance_matched}: balance of the cohort after matching.
}
\description{
This function calls \code{match_cohort_} once and then
removes the pairs whose exposure times do not coincide.
It returns the adjusted cohort, a summary of the matching result,
and the balance of the cohort before and after matching.
}
\keyword{internal}
