% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geography.R
\docType{data}
\name{geography}
\alias{geography}
\title{UK geographic codes an CTRY, RGN and LAD level}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1512 rows and 3 columns.
}
\source{
\url{https://geoportal.statistics.gov.uk/}

Originally licensed under the \href{https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/}{Open Government Licence v3.0}
}
\usage{
data("geography")
}
\description{
Geographic codes and names from the ONS for administrative regions of the UK
relevant to the COVID-19 response. There are multiple entries for lower tier
local authority codes as these changed during the course of the pandemic.
}
\details{
\subsection{\code{geography} dataframe with 1512 rows and 3 columns}{

\describe{
\item{ \code{name} (chr) }{
The region name
}
\item{ \code{code} (chr) }{
The region code
}
\item{ \code{codeType} (chr) }{
The ONS geographical region code type (including year)
}
}
}
}
\examples{
dplyr::glimpse(geography)
}
\concept{datasets}
\keyword{datasets}
