% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power2BinaryExact.R
\name{power2BinaryExact}
\alias{power2BinaryExact}
\title{Exact Power Calculation for Two Co-Primary Binary Endpoints}
\usage{
power2BinaryExact(n1, n2, p11, p12, p21, p22, rho1, rho2, alpha, Test)
}
\arguments{
\item{n1}{Sample size for group 1 (test group)}

\item{n2}{Sample size for group 2 (control group)}

\item{p11}{True probability of responders in group 1 for the first outcome (0 < p11 < 1)}

\item{p12}{True probability of responders in group 1 for the second outcome (0 < p12 < 1)}

\item{p21}{True probability of responders in group 2 for the first outcome (0 < p21 < 1)}

\item{p22}{True probability of responders in group 2 for the second outcome (0 < p22 < 1)}

\item{rho1}{Correlation between the two outcomes for group 1}

\item{rho2}{Correlation between the two outcomes for group 2}

\item{alpha}{One-sided significance level (typically 0.025 or 0.05)}

\item{Test}{Statistical testing method. One of:
\itemize{
\item \code{"Chisq"}: One-sided Pearson chi-squared test
\item \code{"Fisher"}: Fisher exact test
\item \code{"Fisher-midP"}: Fisher mid-p test
\item \code{"Z-pool"}: Z-pooled exact unconditional test
\item \code{"Boschloo"}: Boschloo exact unconditional test
}}
}
\value{
A data frame with the following columns:
\item{n1}{Sample size for group 1}
\item{n2}{Sample size for group 2}
\item{p11, p12, p21, p22}{Response probabilities}
\item{rho1, rho2}{Correlations}
\item{alpha}{One-sided significance level}
\item{Test}{Testing method used}
\item{power1}{Power for the first endpoint alone}
\item{power2}{Power for the second endpoint alone}
\item{powerCoprimary}{Exact power for both co-primary endpoints}
}
\description{
Calculates the exact power for a two-arm superiority trial with two co-primary
binary endpoints using the bivariate binomial distribution, as described in
Homma and Yoshida (2025).
}
\details{
This function calculates exact power using equation (9) in Homma and Yoshida (2025):
\deqn{power_A(\theta) = \sum_{(a_{1,1},a_{2,1})\in\mathcal{A}_1}
      \sum_{(a_{1,2},a_{2,2})\in\mathcal{A}_2} f(a_{1,1}|N_1,p_{1,1}) \times
      f(a_{2,1}|N_2,p_{2,1}) \times g(a_{1,2}|a_{1,1},N_1,p_{1,1},p_{1,2},\gamma_1)
      \times g(a_{2,2}|a_{2,1},N_2,p_{2,1},p_{2,2},\gamma_2)}

where \eqn{\mathcal{A}_k} is the rejection region for endpoint k, and
\eqn{(Y_{j,1}, Y_{j,2}) \sim BiBin(N_j, p_{j,1}, p_{j,2}, \gamma_j)} follows
the bivariate binomial distribution.

The correlation bounds are automatically checked using \code{\link{corrbound2Binary}}.
}
\examples{
# Exact power calculation using Boschloo test
power2BinaryExact(
  n1 = 100,
  n2 = 50,
  p11 = 0.5,
  p12 = 0.4,
  p21 = 0.3,
  p22 = 0.2,
  rho1 = 0.7,
  rho2 = 0.7,
  alpha = 0.025,
  Test = 'Boschloo'
)

# Exact power with Fisher exact test
power2BinaryExact(
  n1 = 80,
  n2 = 80,
  p11 = 0.6,
  p12 = 0.5,
  p21 = 0.4,
  p22 = 0.3,
  rho1 = 0.5,
  rho2 = 0.5,
  alpha = 0.025,
  Test = 'Fisher'
)

\donttest{
# Larger sample sizes (computationally intensive)
power2BinaryExact(
  n1 = 200,
  n2 = 100,
  p11 = 0.5,
  p12 = 0.4,
  p21 = 0.3,
  p22 = 0.2,
  rho1 = 0.6,
  rho2 = 0.6,
  alpha = 0.025,
  Test = 'Chisq'
)
}

}
\references{
Homma, G., & Yoshida, T. (2025). Exact power and sample size in clinical
trials with two co-primary binary endpoints. \emph{Statistical Methods in
Medical Research}, 34(1), 1-19.
}
