% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_remd.R
\name{ts_fil_remd}
\alias{ts_fil_remd}
\title{Robust EMD Filter}
\usage{
ts_fil_remd(noise = 0.1, trials = 5)
}
\arguments{
\item{noise}{noise}

\item{trials}{trials}
}
\value{
A \code{ts_fil_remd} object.
}
\description{
Ensemble/robust EMD-based denoising using CEEMD to separate
noise-dominated IMFs and reconstruct the signal.
}
\examples{
# time series with noise
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2*tsd$y[9]

# filter
filter <- ts_fil_remd()
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# plot
plot_ts_pred(y=tsd$y, yadj=y)
}
\references{
\itemize{
\item Z. Wu and N. E. Huang (2009). Ensemble Empirical Mode Decomposition: a
noise-assisted data analysis method. Advances in Adaptive Data Analysis.
}
}
