% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{TricoloreSextant}
\alias{TricoloreSextant}
\title{Ternary Sextant Color Scale}
\usage{
TricoloreSextant(
  df,
  p1,
  p2,
  p3,
  center = rep(1/3, 3),
  values = c("#FFFF00", "#B3DCC3", "#01A0C6", "#B8B3D8", "#F11D8C", "#FFB3B3"),
  legend = TRUE,
  show_data = TRUE,
  show_center = TRUE,
  label_as = ifelse(identical(center, rep(1/3, 3)), "pct", "pct_diff"),
  crop = FALSE,
  input_validation = TRUE
)
}
\arguments{
\item{df}{Data frame of compositional data.}

\item{p1}{Column name for variable in df giving first proportion
of ternary composition (string).}

\item{p2}{Column name for variable in df giving second proportion
of ternary composition (string).}

\item{p3}{Column name for variable in df giving third proportion
of ternary composition (string).}

\item{center}{Ternary coordinates of the color scale center.
(default = 1/3,1/3,1/3). NA puts center over the compositional
mean of the data.}

\item{values}{6 element character vector of rgb-codes.}

\item{legend}{Should a legend be returned along with the colors? (default=TRUE)}

\item{show_data}{Should the data be shown on the legend? (default=TRUE)}

\item{show_center}{Should the center be shown on the legend?
(default=FALSE if center is at c(1/3, 1/3, 1/3), otherwise TRUE)}

\item{label_as}{"pct" for percent-share labels or "pct_diff" for
percent-point-difference from center labels.
(default='pct' if center is at c(1/3, 1/3, 1/3), otherwise 'pct_diff')}

\item{crop}{Should the legend be cropped to the data? (default=FALSE)}

\item{input_validation}{Should the function arguments be validated? (default=TRUE)}
}
\value{
\itemize{
\item legend=FALSE: A vector of rgbs hex-codes representing the ternary balance
scheme colors.
\item legend=TRUE: A list with elements "rgb" and "key".
}
}
\description{
Color-code three-part compositions with a ternary sextant color scale and
return a color key.
}
\examples{
P <- as.data.frame(prop.table(matrix(runif(3^6), ncol = 3), 1))
TricoloreSextant(P, 'V1', 'V2', 'V3')

}
