% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractVector.R
\name{extractVector}
\alias{extractVector}
\title{Returning a named vector from a treedata.table object}
\usage{
extractVector(tdObject, ...)
}
\arguments{
\item{tdObject}{A treedata.table object}

\item{...}{The name of the column or columns to select.}
}
\value{
A named vector or a list of named vectors
}
\description{
Returning a named vector from a treedata.table object
}
\examples{

data(anolis)
td <- as.treedata.table(tree = anolis$phy, data = anolis$dat)
# extracts the named vector for SVL from the td object
extractVector(td, "SVL")
# extracts the named vector for SVL and ecomorph from the td object
extractVector(td, "SVL", "ecomorph")
}
