% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_r_max.R
\name{get_r_max}
\alias{get_r_max}
\title{Get a Theoretical Maximum Distance for a Tree}
\usage{
get_r_max(counting_factor, area = 10000)
}
\arguments{
\item{counting_factor}{The basal area factor used in counting the trees. For
tally trees in the German national forest inventory its value is 4 [m^2].}

\item{area}{The reference surface in [m^2]. Leave alone.}
}
\value{
A theoretical maximum distance in centimeter. Based on the assumption
that trees have a maximum diameter at breast height of 200 cm.
}
\description{
Maximum distance is of interest as boundaries that are more than double that
distance away are of no interest.
This only a convenience wrapper to \code{\link{get_boundary_radius}}.
}
\examples{
get_r_max(counting_factor = 4)
}
\keyword{internal}
